/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo.generator;

import ch.helvethink.odoo.generator.ClassTools;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassGenerator {
    public static final Logger LOG = LoggerFactory.getLogger((String)ClassGenerator.class.getName());

    private ClassGenerator() {
    }

    /*
     * Unable to fully structure code
     */
    public static void generateClass(List<String> excludedPrefixes, List<String> includedPrefixes, String pathToGenerate, String generatedRootPackage, String modelName, Map<String, Map<String, Object>> fields) throws IOException {
        block16: {
            block17: {
                ClassGenerator.LOG.debug("generating from {}", (Object)modelName);
                rootPackage = StringUtils.isEmpty((String)generatedRootPackage) != false ? "ch.helvethink.odoo.models.generated." : generatedRootPackage + ".";
                classfqdn = ClassGenerator.computeClassFQDN(modelName);
                v0 = mustGenerateClass = StringUtils.isEmpty((String)classfqdn) == false;
                if (!mustGenerateClass || includedPrefixes.isEmpty()) break block17;
                if (includedPrefixes.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)classfqdn))) ** GOTO lbl-1000
            }
            if (!includedPrefixes.isEmpty()) ** GOTO lbl-1000
            if (excludedPrefixes.isEmpty()) ** GOTO lbl-1000
            if (excludedPrefixes.stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)classfqdn))) lbl-1000:
            // 3 sources

            {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = mustGenerateClass = false;
            }
            if (!mustGenerateClass) break block16;
            packageName = classfqdn.substring(0, classfqdn.lastIndexOf("."));
            className = StringUtils.capitaliseAllWords((String)classfqdn.substring(classfqdn.lastIndexOf(".") + 1));
            ClassGenerator.LOG.info("Generating {}{}.{}", new Object[]{rootPackage, packageName, className});
            ClassGenerator.LOG.debug("From modelName, packageName is {} and className is {}", (Object)packageName, (Object)className);
            directory = pathToGenerate + "/" + rootPackage.replace(".", "/") + packageName.replace(".", "/");
            Files.createDirectories(Path.of(directory, new String[0]), new FileAttribute[0]);
            headOfClass = new StringBuilder();
            classContent = new StringBuilder();
            headOfClass.append("package ").append((String)rootPackage).append(packageName).append(";\n");
            headOfClass.append("import ch.helvethink.odoo.models.OdooObject;\n");
            headOfClass.append("import ch.helvethink.odoo.models.OdooObj;\n");
            importsToAdd = new HashSet<Object>();
            classContent.append("@OdooObject(\"").append(modelName).append("\")\n");
            classContent.append("public class ").append(className).append(" implements OdooObj {\n\n");
            for (Map.Entry<String, Map<String, Object>> entry : fields.entrySet()) {
                block18: {
                    fieldProps = entry.getValue();
                    v2 = fieldRelation = fieldProps.get("relation") != null ? ClassGenerator.computeClassFQDN(fieldProps.get("relation").toString()) : null;
                    if (fieldRelation == null) ** GOTO lbl-1000
                    if (includedPrefixes.isEmpty()) break block18;
                    if (includedPrefixes.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)fieldRelation))) ** GOTO lbl-1000
                }
                if (!includedPrefixes.isEmpty()) ** GOTO lbl-1000
                if (excludedPrefixes.isEmpty()) ** GOTO lbl-1000
                if (excludedPrefixes.stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)fieldRelation))) lbl-1000:
                // 4 sources

                {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                fieldMustBeCreated = v3;
                fieldType = ClassTools.getJavaType(fieldProps.get("type").toString());
                v4 = fieldNameSanitized = "boolean".equals(fieldType) != false ? "is" + org.apache.commons.lang3.StringUtils.capitalize((String)entry.getKey()) : entry.getKey();
                if (fieldType.equals("OdooId") && fieldRelation != null && fieldMustBeCreated) {
                    ClassGenerator.LOG.debug("field relation {} has been translated to {}", fieldProps.get("relation"), (Object)fieldRelation);
                    importsToAdd.add("ch.helvethink.odoo.models.OdooId");
                    fieldRelationImport = (String)rootPackage + fieldRelation;
                    if (!fieldRelationImport.equals(packageName)) {
                        importsToAdd.add(fieldRelationImport);
                    }
                    classContent.append("    public " + fieldRelation.substring(fieldRelation.lastIndexOf(".") + 1) + " " + fieldNameSanitized + "AsObject;\n");
                }
                if (fieldType.equals("List<Integer>") && fieldRelation != null && fieldMustBeCreated) {
                    importsToAdd.add("java.util.List");
                    classContent.append("    public List<" + fieldRelation.substring(fieldRelation.lastIndexOf(".") + 1) + "> " + fieldNameSanitized + "AsList;\n");
                    fieldRelationImport = (String)rootPackage + fieldRelation;
                    if (!fieldRelationImport.equals(packageName)) {
                        importsToAdd.add(fieldRelationImport);
                    }
                }
                if (fieldProps.get("relation") != null && fieldMustBeCreated) {
                    importsToAdd.add("ch.helvethink.odoo.models.OdooId");
                    if (fieldRelation != null && !fieldRelation.isEmpty()) {
                        importsToAdd.add("ch.helvethink.odoo.models.FieldRelation");
                        importsToAdd.add("ch.helvethink.odoo.models.OdooModel");
                        classContent.append("    @FieldRelation(\"").append((CharSequence)rootPackage, 0, rootPackage.lastIndexOf(".") + 1).append(fieldRelation).append("\")\n");
                        classContent.append("    @OdooModel(\"").append(fieldRelation).append("\")\n");
                    }
                }
                if (!fieldMustBeCreated) continue;
                classContent.append("    public ").append(fieldType).append(" ").append(fieldNameSanitized).append(";\n");
            }
            classContent.append("}");
            headOfClass.append(importsToAdd.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$generateClass$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).collect(Collectors.joining("\n")));
            headOfClass.append("\n\n");
            fileWriter = new FileWriter(directory + "/" + className + ".java");
            try {
                fileWriter.write(headOfClass.toString());
                fileWriter.write(classContent.toString());
            }
            finally {
                fileWriter.close();
            }
        }
    }

    static String computeClassFQDN(String modelName) {
        String[] splittedModelName = modelName.split("\\.");
        if (modelName.split("\\.").length < 2) {
            return ClassGenerator.computeClassFQDN("generic." + modelName);
        }
        if (Arrays.asList(modelName.split("\\.")).contains("import")) {
            return ClassGenerator.computeClassFQDN(modelName.replace("import", "odooimport"));
        }
        StringBuilder classfqdnSB = new StringBuilder();
        classfqdnSB.append(splittedModelName[0]);
        for (int i = 1; i < splittedModelName.length; ++i) {
            if (i == splittedModelName.length - 1) {
                if (splittedModelName[i - 1].equals(splittedModelName[i].toLowerCase())) {
                    classfqdnSB.append(".").append(org.apache.commons.lang3.StringUtils.capitalize((String)splittedModelName[i].toLowerCase()));
                    continue;
                }
                classfqdnSB.append(".").append(ClassTools.sanitizeClassName(modelName));
                continue;
            }
            classfqdnSB.append(".").append(splittedModelName[i].toLowerCase());
        }
        return classfqdnSB.toString();
    }

    private static /* synthetic */ String lambda$generateClass$0(String imp) {
        return "import " + imp + ";";
    }
}

