/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.jsonrpc;

import ch.helvethink.odoo4java.FetchException;
import ch.helvethink.odoo4java.jsonrpc.JsonRPCRequestBuilder;
import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.models.OdooObj;
import ch.helvethink.odoo4java.models.OdooObject;
import ch.helvethink.odoo4java.rpc.OdooRpcClient;
import ch.helvethink.odoo4java.serialization.OdooObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdooClient
implements OdooRpcClient {
    public static final Logger LOG = LoggerFactory.getLogger((String)OdooClient.class.getName());
    private final String dbName;
    private final String password;
    private final String instanceUrl;
    private final OkHttpClient httpCli;
    int uid;
    private final OdooObjectMapper odooObjectMapper = new OdooObjectMapper();

    public OdooClient(String instanceUrl, String dbName, String username, String password) throws IOException {
        this(new OkHttpClient(), instanceUrl, dbName, username, password, true);
    }

    public OdooClient(OkHttpClient httpCli, String instanceUrl, String dbName, String username, String password, boolean mustConnect) throws IOException {
        this.dbName = dbName;
        this.password = password;
        this.instanceUrl = instanceUrl;
        this.httpCli = httpCli;
        RequestBody body = new JsonRPCRequestBuilder().withMethod("login").withService("common").withParamArgs(dbName, username, password).buildRequest();
        Request request = new Request.Builder().url(instanceUrl + "/jsonrpc").post(body).build();
        this.uid = this.getResult(request).get("result").getAsInt();
    }

    private JsonObject getResult(Request request) throws IOException {
        try (Response response = this.httpCli.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(response.body().string(), JsonObject.class);
                return jsonObject;
            }
            throw new FetchException("No result or something went terribly wrong");
        }
    }

    public <T extends OdooObj> List<T> findByCriteria(int limit, Class<T> classToConvert, String ... criteria) {
        List<List<List<String>>> crits = criteria != null && criteria.length > 0 ? List.of(List.of(Arrays.asList(criteria))) : List.of(List.of(Arrays.asList("id", ">=", "0")));
        LOG.debug("{}", crits);
        return this.genericCall(limit, classToConvert, "search_read", criteria);
    }

    public <T extends OdooObj> T findObjectById(OdooId idToFetch, Class<T> classToConvert) {
        if (idToFetch == null || !idToFetch.exists) {
            return null;
        }
        return (T)((OdooObj)this.findByCriteria(1, classToConvert, "id", "=", String.valueOf(idToFetch.id)).get(0));
    }

    public <T extends OdooObj> List<T> findListByIdsInt(List<Integer> idsToFetch, Class<T> classToConvert) {
        if (idsToFetch == null || idsToFetch.isEmpty()) {
            return Collections.emptyList();
        }
        return this.genericCall(0, classToConvert, "read", idsToFetch);
    }

    public <T extends OdooObj> List<T> findListByIds(List<OdooId> idsToFetch, Class<T> classToConvert) {
        return this.findListByIdsInt(idsToFetch == null ? null : idsToFetch.stream().filter(odooId -> odooId.exists).map(odooId -> odooId.id).toList(), classToConvert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T extends OdooObj> List<T> genericCall(int limit, Class<T> responseType, String method, Object ... requestCriteria) {
        List<Object> criteria = method.equals("name_search") ? Arrays.asList(requestCriteria) : (method.equals("read") ? List.of(requestCriteria) : List.of(List.of(List.of(requestCriteria))));
        JsonObject requestArgs = new JsonObject();
        if (limit > 0) {
            requestArgs.addProperty("limit", (Number)limit);
        }
        RequestBody requestBody = new JsonRPCRequestBuilder().withMethod("execute_kw").withService("object").withParamArgs(this.dbName, this.uid, this.password, responseType.getDeclaredAnnotation(OdooObject.class).value(), method, new Gson().toJsonTree(criteria), requestArgs).buildRequest();
        Request request0 = new Request.Builder().url(this.instanceUrl + "/jsonrpc").post(requestBody).build();
        ArrayList<OdooObj> toReturn = new ArrayList<OdooObj>();
        try (Response response = this.httpCli.newCall(request0).execute();){
            if (!response.isSuccessful()) throw new FetchException(response.message());
            if (response.body() == null) throw new FetchException(response.message());
            if (response.code() < 200) throw new FetchException(response.message());
            if (response.code() >= 300) throw new FetchException(response.message());
            JsonNode jsonTreeResponse = this.odooObjectMapper.readTree(response.body().string());
            JsonNode resultNode = jsonTreeResponse.get("result");
            if (resultNode instanceof ArrayNode) {
                for (int i = 0; i < resultNode.size(); ++i) {
                    toReturn.add((OdooObj)this.odooObjectMapper.convertValue((Object)resultNode.get(i), responseType));
                }
            }
            ArrayList<OdooObj> arrayList = toReturn;
            return arrayList;
        }
        catch (IOException e) {
            throw new FetchException((Exception)e);
        }
    }
}

