/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.jsonrpc;

import ch.helvethink.odoo4java.jsonrpc.LatestRequestBodyHolder;
import ch.helvethink.odoo4java.jsonrpc.ThreadBasedIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRPCRequestBuilder {
    public static final Logger LOG = LoggerFactory.getLogger((String)JsonRPCRequestBuilder.class.getName());
    private final JsonObject params = new JsonObject();
    private final JsonObject requestBody = new JsonObject();
    public static boolean isDebugging = false;

    public JsonRPCRequestBuilder withService(String service) {
        this.params.addProperty("service", service);
        return this;
    }

    public JsonRPCRequestBuilder withMethod(String method) {
        this.params.addProperty("method", method);
        return this;
    }

    public JsonRPCRequestBuilder withParamArgs(JsonElement args) {
        this.params.add("args", args);
        return this;
    }

    public JsonRPCRequestBuilder withParamArgs(Object ... args) {
        return this.withParamArgs(new Gson().toJsonTree((Object)args));
    }

    public RequestBody buildRequest() {
        this.requestBody.addProperty("jsonrpc", "2.0");
        this.requestBody.add("params", (JsonElement)this.params);
        this.requestBody.addProperty("id", (Number)ThreadBasedIdGenerator.generateId());
        String jsonRequest = new Gson().toJson((JsonElement)this.requestBody);
        LOG.debug("The following request will be sent: {}", (Object)jsonRequest);
        if (isDebugging) {
            LatestRequestBodyHolder.sentRequests.push(jsonRequest);
        }
        return RequestBody.create((String)jsonRequest, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
    }
}

