/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.jsonrpc;

import ch.helvethink.odoo4java.FetchException;
import ch.helvethink.odoo4java.jsonrpc.JsonRPCRequestBuilder;
import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.models.OdooObj;
import ch.helvethink.odoo4java.models.OdooObject;
import ch.helvethink.odoo4java.rpc.OdooRpcClient;
import ch.helvethink.odoo4java.serialization.OdooObjectMapper;
import ch.helvethink.odoo4java.tools.CriteriaTools;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdooClient
implements OdooRpcClient {
    public static final Logger LOG = LoggerFactory.getLogger((String)OdooClient.class.getName());
    public static final String JSONRPC_ENDPOINT = "/jsonrpc";
    public static final String RESULT_FIELD = "result";
    private final String dbName;
    private final String password;
    private final String instanceUrl;
    private final OkHttpClient httpCli;
    int uid;
    private final OdooObjectMapper odooObjectMapper = new OdooObjectMapper();

    public OdooClient(String instanceUrl, String dbName, String username, String password) throws IOException {
        this(new OkHttpClient(), instanceUrl, dbName, username, password, true);
    }

    public OdooClient(OkHttpClient httpCli, String instanceUrl, String dbName, String username, String password, boolean mustConnect) throws IOException {
        this.dbName = dbName;
        this.password = password;
        this.instanceUrl = instanceUrl;
        this.httpCli = httpCli;
        RequestBody body = new JsonRPCRequestBuilder().withMethod("login").withService("common").withParamArgs(dbName, username, password).buildRequest();
        Request request = new Request.Builder().url(instanceUrl + JSONRPC_ENDPOINT).post(body).build();
        this.uid = this.getResult(request).get(RESULT_FIELD).getAsInt();
    }

    private JsonObject getResult(Request request) throws IOException {
        try (Response response = this.httpCli.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(response.body().string(), JsonObject.class);
                return jsonObject;
            }
            throw new FetchException("No result or something went terribly wrong");
        }
    }

    public <T extends OdooObj> List<T> findByCriteria(int limit, int page, Class<T> classToConvert, String ... criteria) {
        return this.findByCriteria(limit, page, "", classToConvert, criteria);
    }

    public int countByCriteria(Class<? extends OdooObj> objectType, String ... criteria) {
        JsonObject requestArgs = new JsonObject();
        RequestBody requestBody = new JsonRPCRequestBuilder().withMethod("execute_kw").withService("object").withParamArgs(this.dbName, this.uid, this.password, objectType.getDeclaredAnnotation(OdooObject.class).value(), "search_count", new Gson().toJsonTree((Object)CriteriaTools.groupCriteria((String[])criteria)), requestArgs).buildRequest();
        Request request0 = new Request.Builder().url(this.instanceUrl + JSONRPC_ENDPOINT).post(requestBody).build();
        return this.requestSingleResult(request0);
    }

    public <T extends OdooObj> List<T> findByCriteria(int limit, Class<T> classToConvert, String ... criteria) {
        return this.findByCriteria(limit, 0, "", classToConvert, criteria);
    }

    public <T extends OdooObj> List<T> findByCriteria(int limit, int page, String sortByField, Class<T> classToConvert, String ... criteria) {
        return this.genericCall(limit, page, sortByField, classToConvert, "search_read", (Object[])criteria);
    }

    public <T extends OdooObj> T findObjectById(OdooId idToFetch, Class<T> classToConvert) {
        if (idToFetch == null || !idToFetch.exists) {
            return null;
        }
        List<T> foundObjects = this.findByCriteria(1, classToConvert, "id", "=", String.valueOf(idToFetch.id));
        if (foundObjects.isEmpty()) {
            LOG.warn("No object found with id {} for class {}, this can happen due to old bad unlinked references", (Object)idToFetch.id, classToConvert);
            return null;
        }
        if (foundObjects.size() > 1) {
            LOG.error("Multiple objects with id {} for class {}, this should not happen", (Object)idToFetch.id, classToConvert);
            throw new FetchException("Several objects with the same id");
        }
        return (T)((OdooObj)foundObjects.get(0));
    }

    public <T extends OdooObj> List<T> findListByIdsInt(List<Integer> idsToFetch, Class<T> classToConvert) {
        if (idsToFetch == null || idsToFetch.isEmpty()) {
            return Collections.emptyList();
        }
        return this.genericCall(0, 0, "", classToConvert, "read", idsToFetch);
    }

    public <T extends OdooObj> List<T> findListByIds(List<OdooId> idsToFetch, Class<T> classToConvert) {
        return this.findListByIdsInt(idsToFetch == null ? null : idsToFetch.stream().filter(odooId -> odooId.exists).map(odooId -> odooId.id).toList(), classToConvert);
    }

    public int createOdooObject(OdooObj toSave) {
        return this.genericSave("create", toSave, null);
    }

    public int updateOdooObject(OdooObj toSave, Integer id) {
        return this.genericSave("write", toSave, id);
    }

    public int deleteOdooObject(Integer id, Class<? extends OdooObj> classOfTheObject) {
        JsonRPCRequestBuilder jsonRPCRequestBuilder = new JsonRPCRequestBuilder();
        Object[] params = new Object[]{this.dbName, this.uid, this.password, OdooClient.getOdooObjAnnotation(classOfTheObject), "unlink", new Object[]{Collections.singletonList(id)}, Collections.emptyList()};
        jsonRPCRequestBuilder.withMethod("execute_kw").withService("object").withParamArgs(params);
        RequestBody requestBody = jsonRPCRequestBuilder.buildRequest();
        Request deleteRequest = new Request.Builder().url(this.instanceUrl + JSONRPC_ENDPOINT).post(requestBody).build();
        LOG.debug("Request body: {}", (Object)requestBody);
        return this.requestSingleResult(deleteRequest);
    }

    int genericSave(String method, OdooObj toSave, Integer id) {
        Object[] objectArray;
        JsonRPCRequestBuilder jsonRPCRequestBuilder = new JsonRPCRequestBuilder();
        Object[] objectArray2 = new Object[7];
        objectArray2[0] = this.dbName;
        objectArray2[1] = this.uid;
        objectArray2[2] = this.password;
        objectArray2[3] = toSave.getClass().getDeclaredAnnotation(OdooObject.class).value();
        objectArray2[4] = method;
        if (method.equals("write")) {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = Collections.singletonList(id);
            objectArray = objectArray3;
            objectArray3[1] = this.odooObjectMapper.convertValue((Object)toSave, Map.class);
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = this.odooObjectMapper.convertValue((Object)toSave, Map.class);
        }
        objectArray2[5] = objectArray;
        objectArray2[6] = Collections.emptyList();
        Object[] params = objectArray2;
        jsonRPCRequestBuilder.withMethod("execute_kw").withService("object").withParamArgs(params);
        RequestBody requestBody = jsonRPCRequestBuilder.buildRequest();
        Request saveRequest = new Request.Builder().url(this.instanceUrl + JSONRPC_ENDPOINT).post(requestBody).build();
        return this.requestSingleResult(saveRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int requestSingleResult(Request request) {
        try (Response response = this.httpCli.newCall(request).execute();){
            if (!response.isSuccessful()) throw new FetchException(response.message());
            if (response.body() == null) throw new FetchException(response.message());
            if (response.code() < 200) throw new FetchException(response.message());
            if (response.code() >= 300) throw new FetchException(response.message());
            String responseBody = response.body().string();
            LOG.debug("Response body: {}", (Object)responseBody);
            int n = this.odooObjectMapper.readTree(responseBody).get(RESULT_FIELD).asInt();
            return n;
        }
        catch (IOException e) {
            throw new FetchException((Exception)e);
        }
    }

    <T extends OdooObj> List<T> genericCall(int limit, int page, Class<T> responseType, String method, Object ... requestCriteria) {
        return this.genericCall(limit, page, "", responseType, method, requestCriteria);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T extends OdooObj> List<T> genericCall(int limit, int page, String sortByField, Class<T> responseType, String method, Object ... requestCriteria) {
        Object[] requestCriteriaNotEmpty;
        if (requestCriteria == null || requestCriteria.length == 0) {
            Object[] objectArray = new Object[3];
            objectArray[0] = "id";
            objectArray[1] = ">";
            v1 = objectArray;
            objectArray[2] = "-1";
        } else {
            v1 = requestCriteriaNotEmpty = requestCriteria;
        }
        List<Object> criteria = method.equals("name_search") ? Arrays.asList(requestCriteria) : (method.equals("read") ? List.of(requestCriteriaNotEmpty) : CriteriaTools.groupCriteria((Object[])requestCriteriaNotEmpty));
        JsonObject requestArgs = new JsonObject();
        if (!StringUtils.isEmpty((String)sortByField)) {
            requestArgs.addProperty("order", sortByField);
        }
        if (limit > 0) {
            requestArgs.addProperty("limit", (Number)limit);
            requestArgs.addProperty("offset", (Number)(page * limit));
        }
        RequestBody requestBody = new JsonRPCRequestBuilder().withMethod("execute_kw").withService("object").withParamArgs(this.dbName, this.uid, this.password, responseType.getDeclaredAnnotation(OdooObject.class).value(), method, new Gson().toJsonTree((Object)criteria), requestArgs).buildRequest();
        Request request0 = new Request.Builder().url(this.instanceUrl + JSONRPC_ENDPOINT).post(requestBody).build();
        ArrayList<OdooObj> toReturn = new ArrayList<OdooObj>();
        try (Response response = this.httpCli.newCall(request0).execute();){
            if (!response.isSuccessful()) throw new FetchException(response.message());
            if (response.body() == null) throw new FetchException(response.message());
            if (response.code() < 200) throw new FetchException(response.message());
            if (response.code() >= 300) throw new FetchException(response.message());
            JsonNode jsonTreeResponse = this.odooObjectMapper.readTree(response.body().string());
            JsonNode resultNode = jsonTreeResponse.get(RESULT_FIELD);
            if (resultNode instanceof ArrayNode) {
                for (int i = 0; i < resultNode.size(); ++i) {
                    toReturn.add((OdooObj)this.odooObjectMapper.convertValue((Object)resultNode.get(i), responseType));
                }
            }
            ArrayList<OdooObj> arrayList = toReturn;
            return arrayList;
        }
        catch (IOException e) {
            throw new FetchException((Exception)e);
        }
    }

    private static String getOdooObjAnnotation(Class<? extends OdooObj> classOfTheObject) {
        return classOfTheObject.getDeclaredAnnotation(OdooObject.class).value();
    }
}

