/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.jsonrpc;

import ch.helvethink.odoo4java.FetchException;
import ch.helvethink.odoo4java.jsonrpc.JsonRPCRequestBuilder;
import ch.helvethink.odoo4java.jsonrpc.LatestRequestBodyHolder;
import ch.helvethink.odoo4java.jsonrpc.OdooClient;
import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.models.OdooObj;
import ch.helvethink.odoo4java.models.project.Project;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class OdooClientTest {
    private OdooClient odooClient;
    @Mock
    private OkHttpClient mockHttpClient;
    @Mock
    private Response mockResponse;

    OdooClientTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        MockitoAnnotations.openMocks((Object)this);
        JsonRPCRequestBuilder.isDebugging = true;
        Mockito.when((Object)this.mockResponse.isSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)this.mockResponse.code()).thenReturn((Object)200);
        Mockito.when((Object)this.mockResponse.body()).thenReturn((Object)((ResponseBody)Mockito.mock(ResponseBody.class)));
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)"{\"result\": 1}");
        Mockito.when((Object)this.mockHttpClient.newCall((Request)ArgumentMatchers.any(Request.class))).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.odooClient = new OdooClient(this.mockHttpClient, "http://example.com", "test_db", "user", "password", false);
    }

    @Test
    void testFindObjectById() throws IOException {
        OdooId testId = new OdooId(Integer.valueOf(1));
        Assertions.assertTrue((boolean)testId.exists);
        String mockResponseJson = "{\"jsonrpc\": \"2.0\",\n  \"id\": 1, \"result\": [{\"name\":\"Test Project\"}]}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        Project project = this.odooClient.findObjectById(testId, Project.class);
        Assertions.assertNotNull((Object)project);
        Assertions.assertEquals((Object)"Test Project", (Object)project.getName());
        mockResponseJson = "{\"jsonrpc\": \"2.0\",\n  \"id\": 1, \"result\": []}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        project = this.odooClient.findObjectById(testId, Project.class);
        Assertions.assertNull((Object)project);
        mockResponseJson = "{\"jsonrpc\": \"2.0\",\n  \"id\": 1, \"result\": [{\"name\":\"Test Project\"}, {\"name\":\"Test Project 2\"}]}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        Assertions.assertThrows(FetchException.class, () -> this.odooClient.findObjectById(testId, Project.class));
    }

    @Test
    void testFindObjectByUnknownId() throws IOException {
        OdooId testId = new OdooId(Integer.valueOf(1));
        Assertions.assertTrue((boolean)testId.exists);
        String mockResponseJson = "{\"jsonrpc\": \"2.0\",\n  \"id\": 1, \"result\": [{\"name\":\"Test Project\"}]}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        Project project = this.odooClient.findObjectById(testId, Project.class);
        Assertions.assertNotNull((Object)project);
        Assertions.assertEquals((Object)"Test Project", (Object)project.getName());
    }

    @Test
    void testFindListByIds() throws IOException {
        List<OdooId> testIds = List.of(new OdooId(1, ""), new OdooId(2, "true"));
        String mockResponseJson = "{\"jsonrpc\": \"2.0\",\n  \"id\": 1, \"result\": [{\"name\":\"Project A\"}, {\"name\":\"Project B\"}]}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        List<Project> projects = this.odooClient.findListByIds(testIds, Project.class);
        Assertions.assertNotNull(projects);
        Assertions.assertEquals((int)2, (int)projects.size());
        Assertions.assertEquals((Object)"Project A", (Object)projects.get(0).getName());
        Assertions.assertEquals((Object)"Project B", (Object)projects.get(1).getName());
    }

    @Test
    void testGenericCallValidResponse() throws IOException {
        String mockResponseJson = "{\"result\":[{\"name\":\"Project X\"}]}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        List<Project> projects = this.odooClient.genericCall(10, 0, Project.class, "search_read", "id", ">", "10");
        Assertions.assertNotNull(projects);
        Assertions.assertEquals((int)1, (int)projects.size());
        Assertions.assertEquals((Object)"Project X", (Object)projects.get(0).getName());
    }

    @Test
    void testCreateOdooObject() throws IOException {
        String mockResponseJson = "{\"result\": 10}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        Project p = new Project();
        p.setId(10);
        p.setDisplayName("Test Project");
        int createdProject = this.odooClient.createOdooObject((OdooObj)p);
        Assertions.assertEquals((int)10, (int)createdProject);
        String expected = Files.readString(Path.of("src/test/resources/createProjectTest.json", new String[0]));
        String result = LatestRequestBodyHolder.sentRequests.pop();
        Assertions.assertEquals((Object)expected.substring(0, expected.lastIndexOf("id")), (Object)result.substring(0, result.lastIndexOf("id")));
    }

    @Test
    void testUpdateOdooObject() throws IOException {
        String mockResponseJson = "{\"result\": 10}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        Project p = new Project();
        p.setId(10);
        p.setDisplayName("Update Project");
        int updatedProject = this.odooClient.updateOdooObject((OdooObj)p, 10);
        Assertions.assertEquals((int)10, (int)updatedProject);
        String expected = Files.readString(Path.of("src/test/resources/updateProjectTest.json", new String[0]));
        String result = LatestRequestBodyHolder.sentRequests.pop();
        Assertions.assertEquals((Object)expected.substring(0, expected.lastIndexOf("id")), (Object)result.substring(0, result.lastIndexOf("id")));
    }

    @Test
    void testDeleteOdooObject() throws IOException {
        String mockResponseJson = "{\"result\": 10}";
        Mockito.when((Object)this.mockResponse.body().string()).thenReturn((Object)mockResponseJson);
        int deletedProject = this.odooClient.deleteOdooObject(10, Project.class);
        Assertions.assertEquals((int)10, (int)deletedProject);
        String expected = Files.readString(Path.of("src/test/resources/deleteProjectTest.json", new String[0]));
        String result = LatestRequestBodyHolder.sentRequests.pop();
        Assertions.assertEquals((Object)expected.substring(0, expected.lastIndexOf("id")), (Object)result.substring(0, result.lastIndexOf("id")));
    }
}

