/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.serialization;

import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.models.OdooObj;
import ch.helvethink.odoo4java.models.project.Project;
import ch.helvethink.odoo4java.models.project.ProjectTask;
import ch.helvethink.odoo4java.models.res.ResPartner;
import ch.helvethink.odoo4java.rpc.OdooObjectLoader;
import ch.helvethink.odoo4java.rpc.OdooRpcClient;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

/*
 * Exception performing whole class analysis ignored.
 */
class OdooObjectLoaderTest {
    private ProjectTask projectTask;
    private OdooObjectLoader odooLoader;
    private OdooRpcClient fetcher;

    OdooObjectLoaderTest() {
    }

    @BeforeEach
    public void setUp() {
        this.projectTask = new ProjectTask();
        this.fetcher = (OdooRpcClient)Mockito.mock(OdooRpcClient.class);
        this.odooLoader = new OdooObjectLoader(this.fetcher);
    }

    @Test
    void testFetchRelationShips() {
        Project project = (Project)Mockito.mock(Project.class);
        OdooId projectId = new OdooId(1);
        this.projectTask.setProjectId(projectId);
        Mockito.when((Object)this.fetcher.findObjectById(projectId, Project.class)).thenReturn((Object)project);
        List<Class<? extends OdooObj>> allClasses = OdooObjectLoaderTest.getAllClassesInPackage((String)"ch.helvethink.odoo").stream().toList();
        this.odooLoader.fetchRelationShips(this.projectTask, allClasses);
        Assertions.assertEquals((Object)project, (Object)this.projectTask.getProjectIdAsObject());
    }

    @Test
    void testFetchRecRelationShips() {
        List<ResPartner> resPartnersList = Arrays.asList(new ResPartner(), new ResPartner());
        this.projectTask.setMessagePartnerIds(Arrays.asList(1, 2));
        Mockito.when(this.fetcher.findListByIdsInt(Mockito.anyList(), (Class)ArgumentMatchers.eq(ResPartner.class))).thenReturn(resPartnersList);
        this.odooLoader.fetchRecursivelyRelationShips(this.projectTask, 1, OdooObjectLoaderTest.getAllClassesInPackage((String)"ch.helvethink.odoo").stream().toList());
        Assertions.assertEquals(resPartnersList, (Object)this.projectTask.getMessagePartnerIdsAsList());
    }

    static Set<Class<? extends OdooObj>> getAllClassesInPackage(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[]{new TypeAnnotationsScanner()});
        return reflections.getSubTypesOf(OdooObj.class);
    }
}

