/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.tools;

import ch.helvethink.odoo4java.FetchException;
import ch.helvethink.odoo4java.tools.CriteriaTools;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CriteriaToolsTest {
    CriteriaToolsTest() {
    }

    @Test
    void testGroupCriteriaBadLength() {
        Assertions.assertThrows(FetchException.class, () -> CriteriaTools.groupCriteria(new Object[]{1, 2}));
    }

    @Test
    void testGroupCriteriaObject() {
        List<List<List<Object>>> grouped = CriteriaTools.groupCriteria(new Object[]{"id", ">", 0, "task.id", "=", 1});
        List<List<Object>> resultAsQueryParam = grouped.get(0);
        Assertions.assertEquals((int)2, (int)resultAsQueryParam.size());
        Assertions.assertTrue((boolean)resultAsQueryParam.stream().allMatch(group -> group.size() == 3));
        Assertions.assertEquals(Arrays.asList("id", ">", 0), resultAsQueryParam.get(0));
        Assertions.assertEquals(Arrays.asList("task.id", "=", 1), resultAsQueryParam.get(1));
    }

    @Test
    void testGroupCriteriaString() {
        List<List<List<String>>> grouped = CriteriaTools.groupCriteria(new String[]{"id", ">", "0", "task.id", "=", "1"});
        List<List<String>> resultAsQueryParam = grouped.get(0);
        Assertions.assertEquals((int)2, (int)resultAsQueryParam.size());
        Assertions.assertTrue((boolean)resultAsQueryParam.stream().allMatch(group -> group.size() == 3));
        Assertions.assertEquals(Arrays.asList("id", ">", "0"), resultAsQueryParam.get(0));
        Assertions.assertEquals(Arrays.asList("task.id", "=", "1"), resultAsQueryParam.get(1));
    }
}

