/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.rpc;

import ch.helvethink.odoo4java.FetchException;
import ch.helvethink.odoo4java.models.FieldRelation;
import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.models.OdooObj;
import ch.helvethink.odoo4java.rpc.OdooRpcClient;
import ch.helvethink.odoo4java.tools.FieldUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdooObjectLoader {
    public static final Logger LOG = LoggerFactory.getLogger((String)OdooObjectLoader.class.getName());
    private final OdooRpcClient odooRpcClient;

    public OdooObjectLoader(OdooRpcClient odooRpcClient) {
        this.odooRpcClient = odooRpcClient;
    }

    public void fetchRelationShips(Object o, List<Class<? extends OdooObj>> classesToFetch) {
        this.fetchRecursivelyRelationShips(o, 1, classesToFetch);
    }

    public void fetchRecursivelyRelationShips(Object o, int depth, List<Class<? extends OdooObj>> classesToFetch) {
        if (depth <= 0) {
            return;
        }
        Arrays.stream(o.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(FieldRelation.class)).forEach(fieldRelation -> {
            String fieldToUpdate = FieldUtils.formatFieldName(fieldRelation.getName());
            try {
                Class<?> loadedClass = Class.forName(fieldRelation.getAnnotation(FieldRelation.class).value(), true, Thread.currentThread().getContextClassLoader());
                this.setField(o, depth, classesToFetch, (Field)fieldRelation, loadedClass, fieldToUpdate);
            }
            catch (FetchException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new FetchException(e);
            }
        });
    }

    private void setField(Object o, int depth, List<Class<? extends OdooObj>> classesToFetch, Field fieldRelation, Class<?> loadedClass, String fieldToUpdate) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (OdooObj.class.isAssignableFrom(loadedClass)) {
            Class<?> odooClass = loadedClass;
            if (classesToFetch.isEmpty() || classesToFetch.contains(odooClass)) {
                if (fieldRelation.getType().equals(List.class)) {
                    this.setListRelation(o, depth, classesToFetch, fieldRelation, fieldToUpdate, odooClass);
                } else {
                    this.setSimpleObjectRelation(o, depth, classesToFetch, fieldToUpdate, odooClass);
                }
            }
        } else {
            throw new FetchException("Loaded class does not implement OdooObj");
        }
    }

    private void setSimpleObjectRelation(Object o, int depth, List<Class<? extends OdooObj>> classesToFetch, String fieldToUpdate, Class<? extends OdooObj> aClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object id = o.getClass().getDeclaredMethod("get" + StringUtils.capitalizeFirstLetter((String)fieldToUpdate), new Class[0]).invoke(o, new Object[0]);
        OdooObj fetchedObject = this.odooRpcClient.findObjectById((OdooId)id, aClass);
        o.getClass().getDeclaredMethod("set" + StringUtils.capitalizeFirstLetter((String)fieldToUpdate) + "AsObject", aClass).invoke(o, fetchedObject);
        if (fetchedObject != null) {
            this.fetchRecursivelyRelationShips(fetchedObject, depth - 1, classesToFetch);
        }
    }

    private void setListRelation(Object o, int depth, List<Class<? extends OdooObj>> classesToFetch, Field fieldRelation, String fieldToUpdate, Class<? extends OdooObj> aClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        LOG.debug("fieldRelation: {}", (Object)fieldRelation);
        Object ids = o.getClass().getDeclaredMethod("get" + StringUtils.capitalizeFirstLetter((String)fieldToUpdate), new Class[0]).invoke(o, new Object[0]);
        List<? extends OdooObj> fetchedList = this.odooRpcClient.findListByIdsInt((List)ids, aClass);
        o.getClass().getDeclaredMethod("set" + StringUtils.capitalizeFirstLetter((String)fieldToUpdate) + "AsList", List.class).invoke(o, fetchedList);
        for (OdooObj odooObj : fetchedList) {
            this.fetchRecursivelyRelationShips(odooObj, depth - 1, classesToFetch);
        }
    }
}

