/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.serialization;

import ch.helvethink.odoo4java.serialization.OdooDateDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DateDeserializerTest {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final OdooDateDeserializer dateDeserializer = new OdooDateDeserializer();

    DateDeserializerTest() {
    }

    @Test
    void testDeserialize_BooleanNode_ReturnsNull() throws IOException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        BooleanNode booleanNode = BooleanNode.getFalse();
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)booleanNode);
        Date result = this.dateDeserializer.deserialize(jp, ctxt);
        Assertions.assertNull((Object)result, (String)"Expected null for BooleanNode");
    }

    @Test
    void testDeserialize_ValidDate_ReturnsDate() throws IOException, ParseException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        String dateStr = "2024-11-05";
        JsonNode dateNode = (JsonNode)Mockito.mock(JsonNode.class);
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)dateNode);
        Mockito.when((Object)dateNode.asText()).thenReturn((Object)"2024-11-05");
        Date expectedDate = DATE_FORMAT.parse("2024-11-05");
        Date result = this.dateDeserializer.deserialize(jp, ctxt);
        Assertions.assertEquals((Object)expectedDate, (Object)result, (String)"Expected deserialized date to match input string");
    }

    @Test
    void testDeserialize_InvalidDate_ThrowsRuntimeException() throws IOException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        String invalidDateStr = "invalid-date";
        JsonNode invalidDateNode = (JsonNode)Mockito.mock(JsonNode.class);
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)invalidDateNode);
        Mockito.when((Object)invalidDateNode.asText()).thenReturn((Object)"invalid-date");
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.dateDeserializer.deserialize(jp, ctxt));
        Assertions.assertInstanceOf(ParseException.class, (Object)thrown.getCause(), (String)"Expected a ParseException as cause");
    }
}

