/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OdooDateDeserializer
extends StdDeserializer<Date> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private final SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private final SimpleDateFormat shortDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public OdooDateDeserializer() {
        super(Date.class);
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        try {
            if (BooleanNode.class.equals(node.getClass())) {
                return null;
            }
            String dateAsString = node.asText();
            if (dateAsString.length() > 10) {
                return this.longDateFormat.parse(dateAsString);
            }
            return this.shortDateFormat.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

