/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.serialization;

import ch.helvethink.odoo4java.models.OdooId;
import ch.helvethink.odoo4java.serialization.OdooIdDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class OdooIdDeserializerTest {
    private final OdooIdDeserializer odooIdDeserializer = new OdooIdDeserializer();

    OdooIdDeserializerTest() {
    }

    @Test
    void testDeserialize_BooleanNode_ReturnsOdooId() throws IOException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        BooleanNode booleanNode = BooleanNode.getTrue();
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)booleanNode);
        OdooId result = this.odooIdDeserializer.deserialize(jp, ctxt);
        Assertions.assertNotNull((Object)result, (String)"Expected OdooId to be not null");
        Assertions.assertTrue((boolean)result.exists, (String)"Expected OdooId value to be true");
    }

    @Test
    void testDeserialize_ArrayNode_ReturnsOdooId() throws IOException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        ArrayNode arrayNode = (ArrayNode)Mockito.mock(ArrayNode.class);
        int expectedId = 123;
        String expectedText = "test";
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)arrayNode);
        Mockito.when((Object)arrayNode.get(0)).thenReturn((Object)((JsonNode)Mockito.mock(JsonNode.class)));
        Mockito.when((Object)arrayNode.get(1)).thenReturn((Object)((JsonNode)Mockito.mock(JsonNode.class)));
        Mockito.when((Object)arrayNode.get(0).asInt()).thenReturn((Object)123);
        Mockito.when((Object)arrayNode.get(1).asText()).thenReturn((Object)"test");
        OdooId result = this.odooIdDeserializer.deserialize(jp, ctxt);
        Assertions.assertNotNull((Object)result, (String)"Expected OdooId to be not null");
        Assertions.assertEquals((int)123, (int)result.id, (String)"Expected OdooId id to match");
        Assertions.assertEquals((Object)"test", (Object)result.description, (String)"Expected OdooId text to match");
    }

    @Test
    void testDeserialize_UnknownNode_ReturnsDefaultOdooId() throws IOException {
        JsonParser jp = (JsonParser)Mockito.mock(JsonParser.class);
        DeserializationContext ctxt = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        JsonNode unknownNode = (JsonNode)Mockito.mock(JsonNode.class);
        Mockito.when((Object)jp.getCodec()).thenReturn((Object)((ObjectCodec)Mockito.mock(ObjectMapper.class)));
        Mockito.when((Object)jp.getCodec().readTree(jp)).thenReturn((Object)unknownNode);
        OdooId result = this.odooIdDeserializer.deserialize(jp, ctxt);
        Assertions.assertNotNull((Object)result, (String)"Expected OdooId to be not null");
        Assertions.assertEquals((int)0, (int)result.id, (String)"Expected OdooId id to be default value");
        Assertions.assertNull((Object)result.description, (String)"Expected OdooId text to be null");
    }
}

