/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java;

import ch.helvethink.odoo4java.generator.ClassGenerator;
import ch.helvethink.odoo4java.xmlrpc.OdooClient;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GeneratorMojo
extends AbstractMojo {
    public static final Logger LOG = LoggerFactory.getLogger((String)GeneratorMojo.class.getName());
    public static final String INFO_SEPARATOR = " - ";
    @Parameter(defaultValue="${odoo.username}", property="username", required=true)
    private String odooUsername;
    @Parameter(defaultValue="${odoo.password}", property="password", required=true)
    private String odooPassword;
    @Parameter(defaultValue="${odoo.database}", property="database", required=true)
    private String odooDatabase;
    @Parameter(defaultValue="${odoo.instance}", property="url", required=true)
    private String odooInstanceUrl;
    @Parameter(defaultValue="${odoo.generation.path}", property="path")
    private String generatedClassPath;
    @Parameter(defaultValue="${odoo.generation.package}", property="generationPackage")
    private String generatedClassesRootPackage;
    @Parameter(defaultValue="", property="exclusions")
    private List<String> excludedPrefixes;
    @Parameter(defaultValue="", property="inclusions")
    private List<String> includedPrefixes;

    public void execute() throws MojoExecutionException {
        try {
            String previousExecutionResult;
            Path infoPath;
            String rootPathForGeneratedClasses = StringUtils.isEmpty((String)this.generatedClassPath) ? "target/generated-sources" : this.generatedClassPath;
            OdooClient client = new OdooClient(this.odooInstanceUrl, this.odooDatabase, this.odooUsername, this.odooPassword);
            if (!this.excludedPrefixes.isEmpty() && !this.includedPrefixes.isEmpty()) {
                throw new RuntimeException("excluded and included are mutually exclusive, choose your way");
            }
            StringBuilder infos = new StringBuilder();
            infos.append("odoo server version: ").append(client.getVersion()).append(INFO_SEPARATOR).append("uri: ").append(this.odooInstanceUrl).append(INFO_SEPARATOR).append("user: ").append(this.odooUsername).append(INFO_SEPARATOR).append("generated classes root folder: ").append(this.generatedClassesRootPackage).append(INFO_SEPARATOR).append("generated classes path: ").append(this.generatedClassPath);
            if (LOG.isInfoEnabled()) {
                LOG.info(infos.toString().replace(INFO_SEPARATOR, "\n"));
            }
            if (Files.exists(infoPath = Path.of(rootPathForGeneratedClasses + "/odoo-generator.info", new String[0]), new LinkOption[0]) && (previousExecutionResult = Files.readString(infoPath)).contentEquals(infos)) {
                LOG.info("Classes do not need to be regenerated");
                return;
            }
            List modelsToGenerate = client.getAllModels("");
            for (Map model : modelsToGenerate) {
                String modelName = (String)model.get("model");
                if (modelName.endsWith("Test") || modelName.endsWith("test")) continue;
                ClassGenerator.generateClassNG(this.excludedPrefixes, this.includedPrefixes, rootPathForGeneratedClasses, this.generatedClassesRootPackage, modelName, client.getFields(modelName));
            }
            try (FileWriter fileWriter = new FileWriter(rootPathForGeneratedClasses + "/odoo-generator.info");){
                fileWriter.write(infos.toString());
            }
            LOG.info("Generation of models is finished");
        }
        catch (IOException | XmlRpcException e) {
            throw new MojoExecutionException("Models cannot be generated", (Exception)e);
        }
    }
}

