/*
 * Decompiled with CFR 0.152.
 */
package ch.helvethink.odoo4java.generator;

import org.apache.commons.lang3.StringUtils;

public final class ClassTools {
    private ClassTools() {
    }

    public static String sanitizeClassName(String c) {
        String[] classNameSplitted = c.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String partOfClassName : classNameSplitted) {
            sb.append(StringUtils.capitalize((String)partOfClassName));
        }
        return sb.toString().replace(" ", "").replace(".", "").replace("/", "").replace(",", "").replace("-", "").replace("2", "Two").replace("'", "").replaceAll("\\(.*\\)", "");
    }

    public static String getJavaType(String odooType) {
        return switch (odooType) {
            case "integer" -> "int";
            case "char" -> "String";
            case "boolean" -> "boolean";
            case "float" -> "double";
            case "many2one" -> "OdooId";
            case "one2many", "many2many" -> "List<Integer>";
            case "datetime", "date" -> "Date";
            default -> "Object";
        };
    }
}

