/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.audio;

import ch.hevs.gdx2d.lib.utils.Utils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Disposable;

public class SoundSample
implements Disposable {
    protected Sound s;
    protected float volume = 1.0f;
    protected float pitch = 1.0f;

    public SoundSample(String file) {
        this.s = Gdx.audio.newSound(Gdx.files.internal(file));
        Utils.assertGdxLoaded("A sound sample can only be created in the onInit method of a class extending PortableApplication (or must be called from within this method)");
    }

    public void setVolume(float v) {
        if (v > 1.0f || v < 0.0f) {
            throw new UnsupportedOperationException("Volume must be set in a range between 0 and 1");
        }
        this.volume = v;
    }

    public void setPitch(float p) {
        if (p > 2.0f || p < 0.5f) {
            throw new UnsupportedOperationException("Pitch must be set in a range between 0.5 and 2");
        }
        this.pitch = p;
    }

    public void modifyPitch(float newPitch, long id) {
        this.s.setPitch(id, newPitch);
    }

    public void mofidyPlayingVolument(float newVolume, long id) {
        this.s.setVolume(id, newVolume);
    }

    public long play() {
        return this.s.play(this.volume, this.pitch, 0.0f);
    }

    public void stop() {
        this.s.stop();
    }

    public long loop() {
        return this.s.loop(this.volume, this.pitch, 0.0f);
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

