/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class GlyphLayout
implements Pool.Poolable {
    private static final Array<Color> colorStack = new Array(4);
    public final Array<GlyphRun> runs = new Array();
    public float width;
    public float height;

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public void setText(BitmapFont font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        if (targetWidth == 0.0f) {
            wrap = false;
        }
        if (truncate != null) {
            wrap = true;
        }
        BitmapFont.BitmapFontData fontData = font.data;
        boolean markupEnabled = fontData.markupEnabled;
        Pool<GlyphRun> glyphRunPool = Pools.get(GlyphRun.class);
        glyphRunPool.freeAll(this.runs);
        this.runs.clear();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        int lines = 0;
        Color nextColor = color;
        colorStack.add(color);
        Pool<Color> colorPool = Pools.get(Color.class);
        int runStart = start;
        block4: while (true) {
            int runEnd = -1;
            boolean newline = false;
            if (start == end) {
                if (runStart == end) break;
                runEnd = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        runEnd = start - 1;
                        newline = true;
                        break;
                    }
                    case '[': {
                        int length;
                        if (!markupEnabled || (length = this.parseColorMarkup(str, start, end, colorPool)) < 0) break;
                        runEnd = start - 1;
                        start += length + 1;
                        nextColor = colorStack.peek();
                    }
                }
            }
            if (runEnd == -1) continue;
            GlyphRun run = glyphRunPool.obtain();
            this.runs.add(run);
            run.color.set(color);
            run.x = x;
            run.y = y;
            fontData.getGlyphs(run, str, runStart, runEnd);
            FloatArray xAdvances = run.xAdvances;
            int n = xAdvances.size;
            for (int i = 0; i < n; ++i) {
                float xAdvance = xAdvances.get(i);
                x += xAdvance;
                if (wrap && x > targetWidth && i > 0 && x - (xAdvance - (float)run.glyphs.get((int)i).width) > targetWidth) {
                    if (truncate != null) {
                        this.truncate(fontData, run, targetWidth, truncate, i, glyphRunPool);
                        break block4;
                    }
                    GlyphRun next = glyphRunPool.obtain();
                    this.runs.add(next);
                    this.wrap(fontData, run, next, Math.max(1, fontData.getWrapIndex(run.glyphs, i)), i);
                    width = Math.max(width, run.width);
                    x = 0.0f;
                    ++lines;
                    next.x = 0.0f;
                    next.y = y += fontData.down;
                    i = -1;
                    n = next.xAdvances.size;
                    xAdvances = next.xAdvances;
                    run = next;
                    continue;
                }
                run.width += xAdvance;
            }
            if (newline) {
                width = Math.max(width, x);
                x = 0.0f;
                y += fontData.down;
                ++lines;
            }
            runStart = start;
            color = nextColor;
        }
        width = Math.max(width, x);
        int n = GlyphLayout.colorStack.size;
        for (int i = 1; i < n; ++i) {
            colorPool.free(colorStack.get(i));
        }
        colorStack.clear();
        if ((halign & 8) == 0) {
            boolean center = (halign & 1) != 0;
            float lineWidth = 0.0f;
            float lineY = -2.1474836E9f;
            int lineStart = 0;
            int n2 = this.runs.size;
            for (int i = 0; i < n2; ++i) {
                GlyphRun run = this.runs.get(i);
                if (run.y != lineY) {
                    lineY = run.y;
                    float shift = targetWidth - lineWidth;
                    if (center) {
                        shift /= 2.0f;
                    }
                    while (lineStart < i) {
                        this.runs.get((int)lineStart++).x += shift;
                    }
                    lineWidth = 0.0f;
                }
                lineWidth += run.width;
            }
            float shift = targetWidth - lineWidth;
            if (center) {
                shift /= 2.0f;
            }
            while (lineStart < n2) {
                this.runs.get((int)lineStart++).x += shift;
            }
        }
        this.width = width;
        this.height = fontData.capHeight + (float)lines * fontData.lineHeight;
    }

    private void truncate(BitmapFont.BitmapFontData fontData, GlyphRun run, float targetWidth, String truncate, int widthIndex, Pool<GlyphRun> glyphRunPool) {
        GlyphRun truncateRun = glyphRunPool.obtain();
        fontData.getGlyphs(truncateRun, truncate, 0, truncate.length());
        float truncateWidth = targetWidth;
        int n = truncateRun.glyphs.size;
        for (int i = 0; i < n; ++i) {
            truncateWidth -= truncateRun.xAdvances.get(i);
        }
        while (run.width > truncateWidth) {
            run.width -= run.xAdvances.get(--widthIndex);
        }
        run.glyphs.truncate(widthIndex);
        run.xAdvances.truncate(widthIndex);
        run.glyphs.addAll(truncateRun.glyphs);
        run.xAdvances.addAll(truncateRun.xAdvances);
        run.width += truncateWidth;
        glyphRunPool.free(truncateRun);
    }

    private int parseColorMarkup(CharSequence str, int start, int end, Pool<Color> colorPool) {
        if (start == end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) break;
                        Color color = colorPool.obtain();
                        colorStack.add(color);
                        Color.rgb888ToColor(color, colorInt);
                        if (i <= start + 7) {
                            color.a = 1.0f;
                        }
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    colorInt = colorInt * 16 + (ch - 55);
                }
                return -1;
            }
            case '[': {
                return -1;
            }
            case ']': {
                if (GlyphLayout.colorStack.size > 1) {
                    colorPool.free(colorStack.pop());
                }
                return 0;
            }
        }
        int colorStart = start;
        for (int i = start + 1; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch != ']') continue;
            Color namedColor = Colors.get(str.subSequence(colorStart, i).toString());
            if (namedColor == null) {
                return -1;
            }
            Color color = colorPool.obtain();
            colorStack.add(color);
            color.set(namedColor);
            return i - start;
        }
        return -1;
    }

    private void wrap(BitmapFont.BitmapFontData fontData, GlyphRun first, GlyphRun second, int wrapIndex, int widthIndex) {
        second.color.set(first.color);
        while (widthIndex-- > wrapIndex) {
            first.width -= first.xAdvances.get(widthIndex);
        }
        second.glyphs.addAll(first.glyphs, wrapIndex, first.glyphs.size - wrapIndex);
        second.xAdvances.addAll(first.xAdvances, wrapIndex, first.xAdvances.size - wrapIndex);
        first.glyphs.truncate(wrapIndex);
        first.xAdvances.truncate(wrapIndex);
        for (int i = wrapIndex - 1; i >= 0; --i) {
            char ch = (char)first.glyphs.get((int)i).id;
            if (fontData.isWhitespace(ch)) {
                first.width -= first.xAdvances.get(i);
                continue;
            }
            if (i <= 0) break;
            first.glyphs.truncate(i + 1);
            first.xAdvances.truncate(i + 1);
            break;
        }
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        int n = this.runs.size;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.runs.get(i).toString());
            buffer.append('\n');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public final Array<BitmapFont.Glyph> glyphs = new Array();
        public final FloatArray xAdvances = new FloatArray();
        public float x;
        public float y;
        public float width;
        public final Color color = new Color();

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> glyphs = this.glyphs;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                BitmapFont.Glyph g = glyphs.get(i);
                buffer.append((char)g.id);
            }
            buffer.append(", #");
            buffer.append(this.color);
            buffer.append(", ");
            buffer.append(this.x);
            buffer.append(", ");
            buffer.append(this.y);
            buffer.append(", ");
            buffer.append(this.width);
            return buffer.toString();
        }
    }
}

