/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.graphics;

import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class Polygon {
    private float[] vertices;
    private float[] triangulatedVertices = null;
    public Array<Vector2> vectorList;
    private short[] earClippedVertices;
    private Vector2[] gdxpoints;

    public Polygon(Vector2[] points) {
        int i;
        this.gdxpoints = new Vector2[points.length];
        for (i = 0; i < points.length; ++i) {
            this.gdxpoints[i] = new Vector2(points[i].x, points[i].y);
        }
        this.vertices = new float[points.length * 2];
        for (i = 0; i < points.length; ++i) {
            this.vertices[2 * i] = points[i].x;
            this.vertices[2 * i + 1] = points[i].y;
        }
    }

    public Vector2 getVertex(int i) {
        assert (i < this.vertices.length / 2);
        int t = i * 2;
        return new Vector2(this.vertices[t], this.vertices[t + 1]);
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public float[] getEarClippedVertices() {
        if (this.triangulatedVertices == null) {
            int i;
            float[] vectorArray = new float[this.gdxpoints.length * 2];
            for (i = 0; i < this.gdxpoints.length; ++i) {
                vectorArray[2 * i + 0] = this.gdxpoints[i].x;
                vectorArray[2 * i + 1] = this.gdxpoints[i].y;
            }
            EarClippingTriangulator ect = new EarClippingTriangulator();
            this.earClippedVertices = ect.computeTriangles(vectorArray).toArray();
            this.triangulatedVertices = new float[this.earClippedVertices.length * 2];
            for (i = 0; i < this.earClippedVertices.length; ++i) {
                this.triangulatedVertices[2 * i + 0] = this.gdxpoints[this.earClippedVertices[i]].x;
                this.triangulatedVertices[2 * i + 1] = this.gdxpoints[this.earClippedVertices[i]].y;
            }
        }
        return this.triangulatedVertices;
    }

    public boolean contains(Vector2 p) {
        return Intersector.isPointInPolygon(this.vectorList, new Vector2(p.x, p.y));
    }

    public static float[] vec2floatArray(Vector2[] v) {
        float[] r = new float[2 * v.length];
        int i = 0;
        for (Vector2 f : v) {
            r[i] = f.x;
            r[i + 1] = f.y;
            i += 2;
        }
        return r;
    }

    public static Vector2[] float2vec2(float[] f) {
        assert (f.length % 2 == 0) : "The number of coordinates in a polygon must be even";
        Vector2[] v = new Vector2[f.length / 2];
        for (int i = 0; i < f.length; i += 2) {
            Vector2 n;
            v[i / 2] = n = new Vector2(f[i], f[i + 1]);
        }
        return v;
    }
}

