/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.physics.primitives;

import ch.hevs.gdx2d.components.graphics.Polygon;
import ch.hevs.gdx2d.components.physics.utils.PhysicsConstants;
import ch.hevs.gdx2d.lib.physics.AbstractPhysicsObject;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;

public class PhysicsPolygon
extends AbstractPhysicsObject {
    public PhysicsPolygon(String name, Vector2[] vertices, float density, float restitution, float friction, boolean dynamic) {
        super(name, Vector2.Zero, vertices, density, restitution, friction, dynamic);
    }

    public PhysicsPolygon(String name, Vector2[] vertices, boolean dynamic) {
        super(name, Vector2.Zero, vertices, 1.0f, 0.6f, 0.6f, dynamic);
    }

    public Polygon getPolygon() {
        Fixture f = this.getBody().getFixtureList().get(0);
        assert (f.getType() == Shape.Type.Polygon);
        PolygonShape poly = (PolygonShape)f.getShape();
        assert (poly != null);
        Vector2[] vertices = new Vector2[poly.getVertexCount()];
        assert (poly.getVertexCount() != 0);
        for (int i = 0; i < poly.getVertexCount(); ++i) {
            vertices[i] = new Vector2();
            poly.getVertex(i, vertices[i]);
            Transform t = f.getBody().getTransform();
            t.mul(vertices[i]);
            vertices[i].scl(PhysicsConstants.M2P);
        }
        return new Polygon(vertices);
    }
}

