/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.screen_management.transitions;

import ch.hevs.gdx2d.components.screen_management.transitions.ScreenTransition;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;

public class SmoothTransition
implements ScreenTransition {
    private static final SmoothTransition instance = new SmoothTransition();
    private float duration;

    public static SmoothTransition init(float duration) {
        SmoothTransition.instance.duration = duration;
        return instance;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public void render(SpriteBatch batch, Texture currScreen, Texture nextScreen, float alpha) {
        float w = currScreen.getWidth();
        float h = currScreen.getHeight();
        alpha = Interpolation.fade.apply(alpha);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.begin();
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(currScreen, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight(), false, true);
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(nextScreen, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, nextScreen.getWidth(), nextScreen.getHeight(), false, true);
        batch.end();
    }
}

