/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib.physics;

import ch.hevs.gdx2d.components.physics.utils.PhysicsConstants;
import ch.hevs.gdx2d.lib.physics.BodyInterface;
import ch.hevs.gdx2d.lib.physics.PhysicsWorld;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;

public abstract class AbstractPhysicsObject
implements ContactListener,
BodyInterface {
    private static final BodyDef bodyDef = new BodyDef();
    private final float p2m = PhysicsConstants.P2M;
    private final float m2p = PhysicsConstants.M2P;
    public String name;
    protected Fixture f;
    float lastCollideEnergy = -1.0f;
    private Body body;

    protected AbstractPhysicsObject(Shape.Type t, String name, Vector2 position, float width, float height, float density, float restitution, float friction, boolean isDynamic) {
        this.createObject(t, name, position, width, height, density, restitution, friction, 0.0f, isDynamic);
    }

    protected AbstractPhysicsObject(String name, Vector2 position, Vector2[] vertices, float density, float restitution, float friction, boolean isDynamic) {
        this.createPolygonObject(name, position, vertices, 0.0f, isDynamic, density, restitution, friction);
    }

    protected AbstractPhysicsObject(Shape.Type t, String name, Vector2 position, float width, float height, float density, float restitution, float friction, float angle, boolean isDynamic) {
        this.createObject(t, name, position, width, height, density, restitution, friction, angle, isDynamic);
    }

    private void createPolygonObject(String name, Vector2 position, Vector2[] vertices, float angle, boolean isDynamic, float density, float restitution, float friction) {
        this.name = name;
        Vector2 pos = position.cpy().scl(this.p2m);
        Vector2[] verticesM = new Vector2[vertices.length];
        int i = 0;
        for (Vector2 v : vertices) {
            verticesM[i++] = v.cpy().scl(this.p2m);
        }
        AbstractPhysicsObject.bodyDef.position.set(pos);
        AbstractPhysicsObject.bodyDef.type = isDynamic ? BodyDef.BodyType.DynamicBody : BodyDef.BodyType.StaticBody;
        AbstractPhysicsObject.bodyDef.angle = angle;
        PolygonShape s = new PolygonShape();
        s.set(verticesM);
        World world = PhysicsWorld.getInstance();
        this.body = world.createBody(bodyDef);
        this.createFixture(s, density, restitution, friction);
        s.dispose();
        this.body.setUserData(this);
    }

    private void createObject(Shape.Type t, String name, Vector2 position, float width, float height, float density, float restitution, float friction, float angle, boolean isDynamic) {
        Shape s;
        this.name = name;
        Vector2 pos = position.cpy().scl(this.p2m);
        width *= this.p2m;
        height *= this.p2m;
        AbstractPhysicsObject.bodyDef.position.set(pos);
        AbstractPhysicsObject.bodyDef.type = isDynamic ? BodyDef.BodyType.DynamicBody : BodyDef.BodyType.StaticBody;
        AbstractPhysicsObject.bodyDef.angle = angle;
        if (t == Shape.Type.Circle) {
            s = new CircleShape();
            s.setRadius(width);
        } else {
            PolygonShape p = new PolygonShape();
            p.setAsBox(width / 2.0f, height / 2.0f);
            s = p;
        }
        World world = PhysicsWorld.getInstance();
        this.body = world.createBody(bodyDef);
        this.createFixture(s, density, restitution, friction);
        s.dispose();
        this.body.setUserData(this);
    }

    protected void createFixture(Shape s, float density, float restitution, float friction) {
        FixtureDef def = new FixtureDef();
        def.density = density;
        def.restitution = restitution;
        def.friction = friction;
        def.shape = s;
        def.filter.groupIndex = 1;
        this.f = this.body.createFixture(def);
        this.body.setLinearDamping(0.001f);
    }

    public void destroy() {
        PhysicsWorld.scheduleForDeletion(this.body);
    }

    public void enableCollisionListener() {
        World world = PhysicsWorld.getInstance();
        world.setContactListener(this);
    }

    public void collision(AbstractPhysicsObject theOtherObject, float energy) {
    }

    public void setCollisionGroup(int id) {
        Filter filter = new Filter();
        filter.groupIndex = (short)id;
        for (Fixture f : this.body.getFixtureList()) {
            f.setFilterData(filter);
        }
    }

    @Override
    public void beginContact(Contact contact) {
        AbstractPhysicsObject ob1 = (AbstractPhysicsObject)contact.getFixtureA().getBody().getUserData();
        AbstractPhysicsObject ob2 = (AbstractPhysicsObject)contact.getFixtureB().getBody().getUserData();
        ob1.collision(ob2, this.lastCollideEnergy);
        ob2.collision(ob1, this.lastCollideEnergy);
        this.lastCollideEnergy = -1.0f;
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
        this.lastCollideEnergy = impulse.getNormalImpulses()[0];
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public Vector2 getBodyPosition() {
        return this.body.getPosition().scl(this.m2p);
    }

    @Override
    public Vector2 getBodyLocalCenter() {
        return this.body.getLocalCenter().scl(this.m2p);
    }

    @Override
    public float getBodyAngle() {
        return this.body.getAngle();
    }

    @Override
    public float getBodyAngleDeg() {
        return this.body.getAngle() * 57.29578f;
    }

    @Override
    public float getBodyRadius() {
        if (this.f.getShape().getType() == Shape.Type.Circle) {
            return this.f.getShape().getRadius() * this.m2p;
        }
        throw new UnsupportedOperationException("Only circle shapes have radius");
    }

    @Override
    public void applyBodyTorque(float torque, boolean wake) {
        this.body.applyTorque(torque, wake);
    }

    @Override
    public float getBodyAngularDamping() {
        return this.body.getAngularDamping();
    }

    @Override
    public void setBodyAngularDamping(float damping) {
        this.body.setAngularDamping(damping);
    }

    @Override
    public float getBodyLinearDamping() {
        return this.body.getLinearDamping();
    }

    @Override
    public void setBodyLinearDamping(float damping) {
        this.body.setLinearDamping(damping);
    }

    @Override
    public Vector2 getBodyLinearVelocity() {
        return this.body.getLinearVelocity();
    }

    @Override
    public void setBodyLinearVelocity(Vector2 v) {
        this.body.setLinearVelocity(v);
    }

    public Vector2 getBodyLinearVelocityPixels() {
        return this.body.getLinearVelocity().scl(this.m2p);
    }

    @Override
    public Vector2 getBodyLinearVelocityFromLocalPoint(Vector2 v) {
        return this.body.getLinearVelocityFromLocalPoint(v.scl(this.p2m)).scl(this.m2p);
    }

    @Override
    public Vector2 getBodyLinearVelocityFromWorldPoint(Vector2 v) {
        return this.body.getLinearVelocityFromWorldPoint(v.scl(this.p2m)).scl(this.m2p);
    }

    @Override
    public float getBodyAngularVelocity() {
        return this.body.getAngularVelocity();
    }

    @Override
    public Array<Fixture> getBodyFixtureList() {
        return this.body.getFixtureList();
    }

    @Override
    public float getBodyGravityScale() {
        return this.body.getGravityScale();
    }

    @Override
    public float getBodyInertia() {
        return this.body.getInertia();
    }

    @Override
    public Vector2 getBodyLocalPoint(Vector2 v) {
        return this.body.getLocalPoint(v.scl(this.p2m)).scl(this.m2p);
    }

    @Override
    public Vector2 getBodyLocalVector(Vector2 v) {
        return this.body.getLocalVector(v.scl(this.p2m)).scl(this.m2p);
    }

    @Override
    public float getBodyMass() {
        return this.body.getMass();
    }

    @Override
    public MassData getBodyMassData() {
        return this.body.getMassData();
    }

    @Override
    public Transform getBodyTransform() {
        return this.body.getTransform();
    }

    @Override
    public World getBodyWorld() {
        return this.body.getWorld();
    }

    @Override
    public Vector2 getBodyWorldCenter() {
        return this.body.getWorldCenter().scl(this.m2p);
    }

    @Override
    public Vector2 getBodyWorldPoint(Vector2 v) {
        return this.body.getWorldPoint(v.scl(this.p2m)).cpy().scl(this.m2p);
    }

    @Override
    public Vector2 getBodyWorldVector(Vector2 v) {
        return this.body.getWorldVector(v.scl(this.p2m)).cpy().scl(this.m2p);
    }

    @Override
    public boolean isBodyActive() {
        return this.body.isActive();
    }

    @Override
    public void setBodyActive(boolean active) {
        this.body.setActive(active);
    }

    @Override
    public boolean isBodyAwake() {
        return this.body.isAwake();
    }

    @Override
    public void setBodyAwake(boolean awake) {
        this.body.setAwake(awake);
    }

    @Override
    public boolean isBodyBullet() {
        return this.body.isBullet();
    }

    @Override
    public boolean isBodyFixedRotation() {
        return this.body.isFixedRotation();
    }

    @Override
    public boolean isBodySleepingAllowed() {
        return this.body.isSleepingAllowed();
    }

    @Override
    public void setBodyLinearVelocity(float vx, float vy) {
        this.body.setLinearVelocity(vx, vy);
    }

    @Override
    public void applyBodyAngularImpulse(float impulse, boolean wake) {
        this.body.applyAngularImpulse(impulse, wake);
    }

    @Override
    public void applyBodyForce(float forceX, float forceY, float pointX, float pointY, boolean wake) {
        this.body.applyForce(forceX, forceY, pointX, pointY, wake);
    }

    @Override
    public void applyBodyForce(Vector2 force, Vector2 point, boolean wake) {
        this.body.applyForce(force, point, wake);
    }

    @Override
    public void applyBodyForceToCenter(float forceX, float forceY, boolean wake) {
        this.body.applyForceToCenter(forceX, forceY, wake);
    }

    @Override
    public void applyBodyForceToCenter(Vector2 force, boolean wake) {
        this.body.applyForceToCenter(force, wake);
    }

    @Override
    public void applyBodyLinearImpulse(float impulseX, float impulseY, float pointX, float pointY, boolean wake) {
        this.body.applyLinearImpulse(impulseX, impulseY, pointX, pointY, wake);
    }

    @Override
    public void applyBodyLinearImpulse(Vector2 impulse, Vector2 point, boolean wake) {
        this.body.applyLinearImpulse(impulse, point, wake);
    }

    public void setSensor(boolean enable) {
        for (Fixture x : this.getBody().getFixtureList()) {
            x.setSensor(true);
        }
    }

    public Body getBody() {
        return this.body;
    }
}

