/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.audio;

import ch.hevs.gdx2d.lib.utils.Logger;
import ch.hevs.gdx2d.lib.utils.Utils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class MusicPlayer
implements Disposable {
    protected Music s;
    protected float volume = 1.0f;

    public MusicPlayer(String file) {
        try {
            this.s = Gdx.audio.newMusic(Gdx.files.internal(file));
            Utils.assertGdxLoaded("MusicPlayers can only be created in the onInit method of a class extending PortableApplication (or must be called from within this method)");
        }
        catch (GdxRuntimeException e) {
            Logger.error("Unable to load the music" + file);
            Gdx.app.exit();
        }
    }

    public void setVolume(float v) {
        if (v > 1.0f || v < 0.0f) {
            throw new UnsupportedOperationException("Volume must be set in a range between 0 and 1");
        }
        this.volume = v;
    }

    public void play() {
        this.s.play();
    }

    public void stop() {
        this.s.stop();
    }

    public boolean isPlaying() {
        return this.s.isPlaying();
    }

    public boolean isLooping() {
        return this.s.isLooping();
    }

    public void loop() {
        this.s.play();
        this.s.setLooping(true);
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

