/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.bitmaps;

import ch.hevs.gdx2d.lib.utils.Utils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;

public final class BitmapImage
implements Disposable {
    protected Texture image;
    protected TextureRegion tRegion;
    protected String filePath;
    protected Pixmap pixmap;

    public BitmapImage(String file) {
        Utils.assertGdxLoaded("BitmapImages can only be created in the onInit method of a class extending PortableApplication (or must be called from within this method)");
        this.image = new Texture(Gdx.files.internal(file));
        this.tRegion = new TextureRegion(this.image);
        this.image.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.filePath = file;
    }

    public Texture getImage() {
        return this.image;
    }

    public TextureRegion getRegion() {
        return this.tRegion;
    }

    public void mirrorLeftRight() {
        this.tRegion.flip(true, false);
    }

    public void mirrorUpDown() {
        this.tRegion.flip(false, true);
    }

    public boolean isContained(Vector2 p) {
        return this.isContained((int)p.x, (int)p.y);
    }

    public boolean isContained(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return x < this.image.getWidth() && y < this.image.getHeight();
    }

    public Vector2 pixelInScreenSpace(Vector2 pixelPosition, Vector2 imagePosition) {
        int width = this.image.getWidth();
        int height = this.image.getWidth();
        Vector2 center = pixelPosition.sub(imagePosition);
        center.add(width / 2, height / 2);
        return center;
    }

    public Color getColor(int x, int y) {
        if (this.pixmap == null) {
            if (!this.image.getTextureData().isPrepared()) {
                this.image.getTextureData().prepare();
            }
            this.pixmap = this.image.getTextureData().consumePixmap();
        }
        return new Color(this.pixmap.getPixel(x, this.pixmap.getHeight() - y));
    }

    @Override
    public void dispose() {
        if (this.pixmap != null && this.image.getTextureData().disposePixmap()) {
            this.pixmap.dispose();
        }
        this.image.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

