/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.colors;

import com.badlogic.gdx.graphics.Color;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static Color hsvToColor(float hue, float saturation, float value) {
        return ColorUtils.intToColor(ColorUtils.hsvToRgb(hue, saturation, value));
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (h) {
            case 0: {
                return ColorUtils.rgbToInt(value, t, p);
            }
            case 1: {
                return ColorUtils.rgbToInt(q, value, p);
            }
            case 2: {
                return ColorUtils.rgbToInt(p, value, t);
            }
            case 3: {
                return ColorUtils.rgbToInt(p, q, value);
            }
            case 4: {
                return ColorUtils.rgbToInt(t, p, value);
            }
            case 5: {
                return ColorUtils.rgbToInt(value, p, q);
            }
        }
        throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
    }

    public static int rgbToInt(float r, float g, float b) {
        return Color.rgb888(r, g, b);
    }

    public static Color intToColor(int col) {
        float r = (float)((col & 0xFF0000) >>> 16) / 255.0f;
        float g = (float)((col & 0xFF00) >>> 8) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        return new Color(r, g, b, 1.0f);
    }
}

