/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.screen_management.transitions;

import ch.hevs.gdx2d.components.screen_management.transitions.ScreenTransition;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.Array;

public class SliceTransition
implements ScreenTransition {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int UP_DOWN = 3;
    private static final SliceTransition instance = new SliceTransition();
    private float duration;
    private int direction;
    private Interpolation easing;
    private Array<Integer> sliceIndex = new Array();

    public static SliceTransition init(float duration, int direction, int numSlices, Interpolation easing) {
        SliceTransition.instance.duration = duration;
        SliceTransition.instance.direction = direction;
        SliceTransition.instance.easing = easing;
        SliceTransition.instance.sliceIndex.clear();
        for (int i = 0; i < numSlices; ++i) {
            SliceTransition.instance.sliceIndex.add(i);
        }
        SliceTransition.instance.sliceIndex.shuffle();
        return instance;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public void render(SpriteBatch batch, Texture currScreen, Texture nextScreen, float alpha) {
        float w = currScreen.getWidth();
        float h = currScreen.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        int sliceWidth = (int)(w / (float)this.sliceIndex.size);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.begin();
        batch.draw(currScreen, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight(), false, true);
        if (this.easing != null) {
            alpha = this.easing.apply(alpha);
        }
        for (int i = 0; i < this.sliceIndex.size; ++i) {
            x = i * sliceWidth;
            float offsetY = h * (1.0f + (float)this.sliceIndex.get(i).intValue() / (float)this.sliceIndex.size);
            switch (this.direction) {
                case 1: {
                    y = -offsetY + offsetY * alpha;
                    break;
                }
                case 2: {
                    y = offsetY - offsetY * alpha;
                    break;
                }
                case 3: {
                    y = i % 2 == 0 ? -offsetY + offsetY * alpha : offsetY - offsetY * alpha;
                }
            }
            batch.draw(nextScreen, x, y, 0.0f, 0.0f, sliceWidth, h, 1.0f, 1.0f, 0.0f, i * sliceWidth, 0, sliceWidth, nextScreen.getHeight(), false, true);
        }
        batch.end();
    }
}

