/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.screen_management.transitions;

import ch.hevs.gdx2d.components.screen_management.transitions.ScreenTransition;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;

public class SlideTransition
implements ScreenTransition {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private static final SlideTransition instance = new SlideTransition();
    private float duration;
    private int direction;
    private boolean slideOut;
    private Interpolation easing;

    public static SlideTransition init(float duration, int direction, boolean slideOut, Interpolation easing) {
        SlideTransition.instance.duration = duration;
        SlideTransition.instance.direction = direction;
        SlideTransition.instance.slideOut = slideOut;
        SlideTransition.instance.easing = easing;
        return instance;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public void render(SpriteBatch batch, Texture currScreen, Texture nextScreen, float alpha) {
        float w = currScreen.getWidth();
        float h = currScreen.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        if (this.easing != null) {
            alpha = this.easing.apply(alpha);
        }
        switch (this.direction) {
            case 1: {
                x = -w * alpha;
                if (this.slideOut) break;
                x += w;
                break;
            }
            case 2: {
                x = w * alpha;
                if (this.slideOut) break;
                x -= w;
                break;
            }
            case 3: {
                y = h * alpha;
                if (this.slideOut) break;
                y -= h;
                break;
            }
            case 4: {
                y = -h * alpha;
                if (this.slideOut) break;
                y += h;
            }
        }
        Texture texBottom = this.slideOut ? nextScreen : currScreen;
        Texture texTop = this.slideOut ? currScreen : nextScreen;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.begin();
        batch.draw(texBottom, 0.0f, 0.0f, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, currScreen.getWidth(), currScreen.getHeight(), false, true);
        batch.draw(texTop, x, y, 0.0f, 0.0f, w, h, 1.0f, 1.0f, 0.0f, 0, 0, nextScreen.getWidth(), nextScreen.getHeight(), false, true);
        batch.end();
    }
}

