/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.desktop;

import ch.hevs.gdx2d.desktop.PortableApplication;
import ch.hevs.gdx2d.lib.GdxGraphics;
import ch.hevs.gdx2d.lib.Version;
import ch.hevs.gdx2d.lib.physics.PhysicsWorld;
import ch.hevs.gdx2d.lib.utils.Logger;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.GdxNativesLoader;

public class Game2D
implements ApplicationListener {
    public static GdxGraphics g;
    public OrthographicCamera camera;
    protected PortableApplication app;
    protected ShapeRenderer shapeRenderer;
    protected SpriteBatch batch;

    public Game2D(PortableApplication app) {
        this.app = app;
    }

    @Override
    public void create() {
        this.shapeRenderer = new ShapeRenderer();
        this.batch = new SpriteBatch();
        Logger.log(Version.printVerbose());
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.camera.update();
        g = new GdxGraphics(this.shapeRenderer, this.batch, this.camera);
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor(new GestureDetector(new GestureDetector.GestureListener(){

            @Override
            public boolean zoom(float initialDistance, float distance) {
                Game2D.this.app.onZoom(initialDistance, distance);
                return false;
            }

            @Override
            public boolean touchDown(float x, float y, int pointer, int button) {
                return false;
            }

            @Override
            public boolean tap(float x, float y, int count, int button) {
                Game2D.this.app.onTap(x, y, count, button);
                return false;
            }

            @Override
            public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
                Game2D.this.app.onPinch(initialPointer1, initialPointer2, pointer1, pointer2);
                return false;
            }

            @Override
            public boolean pan(float x, float y, float deltaX, float deltaY) {
                Game2D.this.app.onPan(x, y, deltaX, deltaY);
                return false;
            }

            @Override
            public boolean longPress(float x, float y) {
                Game2D.this.app.onLongPress(x, y);
                return false;
            }

            @Override
            public boolean fling(float velocityX, float velocityY, int button) {
                Game2D.this.app.onFling(velocityX, velocityY, button);
                return false;
            }

            @Override
            public boolean panStop(float v, float v1, int i, int i1) {
                return false;
            }
        }));
        multiplexer.addProcessor(new InputProcessor(){

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                Game2D.this.app.onRelease(screenX, screenY, button);
                return false;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                Game2D.this.app.onDrag(screenX, Gdx.graphics.getHeight() - screenY);
                return false;
            }

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                Game2D.this.app.onClick(screenX, Gdx.graphics.getHeight() - screenY, button);
                return false;
            }

            @Override
            public boolean scrolled(int amount) {
                Game2D.this.app.onScroll(amount);
                return false;
            }

            @Override
            public boolean mouseMoved(int screenX, int screenY) {
                return false;
            }

            @Override
            public boolean keyUp(int keycode) {
                Game2D.this.app.onKeyUp(keycode);
                return false;
            }

            @Override
            public boolean keyTyped(char character) {
                return false;
            }

            @Override
            public boolean keyDown(int keycode) {
                if (keycode == 82) {
                    // empty if block
                }
                if (keycode == 131) {
                    Gdx.app.exit();
                }
                Game2D.this.app.onKeyDown(keycode);
                return false;
            }
        });
        Gdx.input.setInputProcessor(multiplexer);
        this.app.onInit();
    }

    @Override
    public void render() {
        g.begin();
        this.app.onGraphicRender(g);
        g.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
        this.app.onPause();
    }

    @Override
    public void resume() {
        this.app.onResume();
    }

    @Override
    public void dispose() {
        PhysicsWorld.dispose();
        g.dispose();
        this.app.onDispose();
    }

    static {
        GdxNativesLoader.load();
    }
}

