/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib;

import ch.hevs.gdx2d.components.bitmaps.BitmapImage;
import ch.hevs.gdx2d.components.graphics.Polygon;
import ch.hevs.gdx2d.lib.renderers.CircleShaderRenderer;
import ch.hevs.gdx2d.lib.renderers.ShaderRenderer;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class GdxGraphics
implements Disposable {
    protected final Texture logoTex = new Texture(Gdx.files.internal("res/lib/logo_hes.png"));
    protected final Texture circleTex = new Texture(Gdx.files.internal("res/lib/circle.png"));
    protected SpriteBatch spriteBatch;
    protected OrthographicCamera camera;
    protected OrthographicCamera fixedCamera;
    protected BitmapFont font;
    protected Color currentColor = Color.WHITE;
    protected Color backgroundColor = Color.BLACK;
    private ShapeRenderer shapeRenderer;
    private CircleShaderRenderer circleRenderer;
    private ShaderRenderer shaderRenderer;
    private RenderingMode renderingMode = RenderingMode.NONE;

    public GdxGraphics(ShapeRenderer shapeRenderer, SpriteBatch spriteBatch, OrthographicCamera camera) {
        this.shapeRenderer = shapeRenderer;
        this.spriteBatch = spriteBatch;
        this.camera = camera;
        this.circleRenderer = new CircleShaderRenderer();
        FileHandle robotoF = Gdx.files.internal("res/lib/RobotoSlab-Regular.ttf");
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(robotoF);
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.color = Color.WHITE;
        parameter.size = 15;
        this.font = generator.generateFont(parameter);
        generator.dispose();
        this.fixedCamera = new OrthographicCamera();
        this.fixedCamera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClear(16384);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
    }

    @Override
    public void dispose() {
        this.logoTex.dispose();
        this.circleTex.dispose();
        this.font.dispose();
        this.spriteBatch.dispose();
        if (this.getShaderRenderer() != null) {
            this.getShaderRenderer().dispose();
        }
    }

    private void resetRenderingMode() {
        this.checkMode(RenderingMode.NONE);
    }

    public void drawFPS() {
        this.drawFPS(Color.WHITE);
    }

    public void drawFPS(Color c) {
        this.spriteBatch.setProjectionMatrix(this.fixedCamera.combined);
        Color oldColor = this.font.getColor();
        this.font.setColor(c);
        this.drawString(5.0f, 15.0f, "FPS: " + Gdx.graphics.getFramesPerSecond());
        this.font.setColor(oldColor);
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
    }

    public void drawSchoolLogo() {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.setProjectionMatrix(this.fixedCamera.combined);
        this.spriteBatch.draw(this.logoTex, (float)(this.getScreenWidth() - this.logoTex.getWidth()), 0.0f);
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
    }

    public void drawSchoolLogoUpperRight() {
        this.checkMode(RenderingMode.SPRITE);
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        this.spriteBatch.setProjectionMatrix(this.fixedCamera.combined);
        this.spriteBatch.draw(this.logoTex, (float)(width - this.logoTex.getWidth()), (float)(height - this.logoTex.getHeight()));
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
    }

    private void checkMode(RenderingMode mode) {
        if (mode == this.renderingMode) {
            return;
        }
        switch (this.renderingMode) {
            case SPRITE: {
                this.spriteBatch.end();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                this.shapeRenderer.end();
            }
        }
        switch (mode) {
            case SHAPE_LINE: {
                this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
                this.shapeRenderer.setProjectionMatrix(this.camera.combined);
                break;
            }
            case SHAPE_FILLED: {
                this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
                this.shapeRenderer.setProjectionMatrix(this.camera.combined);
                break;
            }
            case SHAPE_POINT: {
                this.shapeRenderer.begin(ShapeRenderer.ShapeType.Point);
                this.shapeRenderer.setProjectionMatrix(this.camera.combined);
                this.shapeRenderer.identity();
                break;
            }
            case SPRITE: {
                this.spriteBatch.begin();
                this.spriteBatch.setProjectionMatrix(this.camera.combined);
                break;
            }
        }
        this.renderingMode = mode;
    }

    public void setPenWidth(float width) {
        this.checkMode(RenderingMode.SPRITE);
        Gdx.gl20.glLineWidth(width);
    }

    public int getScreenHeight() {
        return Gdx.graphics.getHeight();
    }

    public int getScreenWidth() {
        return Gdx.graphics.getWidth();
    }

    public void clear() {
        this.clear(this.backgroundColor);
    }

    public void begin() {
    }

    public void end() {
        this.checkMode(RenderingMode.NONE);
    }

    public void clear(Color c) {
        Gdx.gl.glClearColor(c.r, c.g, c.b, c.a);
        Gdx.gl.glClear(16384);
    }

    public void setColor(Color c) {
        this.currentColor = c;
        this.shapeRenderer.setColor(c);
        this.font.setColor(c);
    }

    public void setPixel(float x, float y) {
        this.setPixel(x, y, this.currentColor);
    }

    public void setPixel(float x, float y, Color c) {
        this.checkMode(RenderingMode.SHAPE_POINT);
        this.shapeRenderer.setColor(c);
        this.shapeRenderer.point(x, y, 0.0f);
        this.shapeRenderer.setColor(this.currentColor);
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public void clearPixel(float x, float y) {
        this.clearPixel(x, y, this.backgroundColor);
    }

    public void clearPixel(float x, float y, Color c) {
        this.checkMode(RenderingMode.SHAPE_POINT);
        this.shapeRenderer.identity();
        this.shapeRenderer.setColor(c);
        this.shapeRenderer.point(x, y, 0.0f);
        this.shapeRenderer.setColor(this.currentColor);
    }

    public void drawLine(float p1x, float p1y, float p2x, float p2y) {
        this.checkMode(RenderingMode.SHAPE_LINE);
        this.shapeRenderer.identity();
        this.shapeRenderer.setColor(this.currentColor);
        this.shapeRenderer.line(p1x, p1y, p2x, p2y);
    }

    public void drawLine(float p1x, float p1y, float p2x, float p2y, Color c) {
        this.shapeRenderer.setColor(c);
        this.drawLine(p1x, p1y, p2x, p2y);
        this.shapeRenderer.setColor(this.currentColor);
    }

    public void drawRectangle(float x, float y, float w, float h, float angle) {
        this.checkMode(RenderingMode.SHAPE_LINE);
        this.shapeRenderer.identity();
        this.shapeRenderer.translate(x, y, 0.0f);
        this.shapeRenderer.rotate(0.0f, 0.0f, 1.0f, angle);
        this.shapeRenderer.rect(-w / 2.0f, -h / 2.0f, w, h);
    }

    public void drawFilledRectangle(float x, float y, float w, float h, float angle) {
        this.checkMode(RenderingMode.SHAPE_FILLED);
        this.shapeRenderer.identity();
        this.shapeRenderer.translate(x, y, 0.0f);
        this.shapeRenderer.rotate(0.0f, 0.0f, 1.0f, angle);
        this.shapeRenderer.rect(-w / 2.0f, -h / 2.0f, w, h);
    }

    public void drawFilledRectangle(float x, float y, float w, float h, float angle, Color c) {
        this.shapeRenderer.setColor(c);
        this.drawFilledRectangle(x, y, w, h, angle);
        this.shapeRenderer.setColor(this.currentColor);
    }

    public void drawCircle(float centerX, float centerY, float radius, Color c) {
        this.shapeRenderer.setColor(c);
        this.drawCircle(centerX, centerY, radius);
        this.shapeRenderer.setColor(this.currentColor);
    }

    public void drawCircle(float centerX, float centerY, float radius) {
        this.checkMode(RenderingMode.SHAPE_LINE);
        this.shapeRenderer.circle(centerX, centerY, radius);
    }

    public void drawAntiAliasedCircle(float centerX, float centerY, float radius, Color c) {
        this.circleRenderer.setColor(new Vector3(c.r, c.g, c.b));
        this.circleRenderer.setPosition(new Vector2(centerX, centerY));
        this.circleRenderer.setRadius(radius);
        this.circleRenderer.render();
    }

    public void drawFilledCircle(float centerX, float centerY, float radius, Color c) {
        if (radius > 100.0f) {
            this.checkMode(RenderingMode.SHAPE_FILLED);
            this.shapeRenderer.setColor(c);
            this.shapeRenderer.identity();
            this.shapeRenderer.circle(centerX, centerY, radius);
            this.shapeRenderer.setColor(this.currentColor);
        } else {
            Color old = this.spriteBatch.getColor();
            this.checkMode(RenderingMode.SPRITE);
            this.spriteBatch.setColor(c);
            this.spriteBatch.draw(this.circleTex, centerX - 64.0f, centerY - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, radius / 64.0f, radius / 64.0f, 0.0f, 0, 0, 128, 128, false, false);
            this.spriteBatch.setColor(old);
        }
    }

    public void drawFilledBorderedCircle(float centerX, float centerY, float radius, Color inner, Color outer) {
        this.checkMode(RenderingMode.SPRITE);
        this.drawFilledCircle(centerX, centerY, radius + 3.0f, outer);
        this.drawFilledCircle(centerX, centerY, radius + 1.0f, inner);
    }

    public void drawString(float posX, float posY, String str) {
        this.drawString(posX, posY, str, this.font);
    }

    public void drawString(float posX, float posY, String str, BitmapFont f) {
        this.drawString(posX, posY, str, f, 8);
    }

    public void drawString(float posX, float posY, String str, int align) {
        this.drawString(posX, posY, str, this.font, align);
    }

    public void drawString(float posX, float posY, String str, BitmapFont f, int align) {
        this.checkMode(RenderingMode.SPRITE);
        float w = f.getScaleX();
        f.draw(this.spriteBatch, str, posX, posY, w, align, false);
    }

    public void drawStringCentered(float posY, String str) {
        this.drawString((float)this.getScreenWidth() / 2.0f, posY, str, 1);
    }

    public void drawStringCentered(float posY, String str, BitmapFont f) {
        this.drawString((float)this.getScreenWidth() / 2.0f, posY, str, f, 1);
    }

    public void drawBackground(BitmapImage t, float i, float j) {
        this.drawBackground(t.getImage(), i, j);
    }

    public void drawBackground(Texture t, float i, float j) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.setProjectionMatrix(this.fixedCamera.combined);
        this.spriteBatch.disableBlending();
        this.spriteBatch.draw(t, i, j);
        this.spriteBatch.enableBlending();
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
    }

    public void drawPicture(float posX, float posY, BitmapImage bitmap) {
        this.drawTransformedPicture(posX, posY, 0.0f, 1.0f, bitmap);
    }

    public void drawTransformedPicture(float posX, float posY, float angle, float scale, BitmapImage bitmap) {
        this.drawTransformedPicture(posX, posY, bitmap.getImage().getWidth() / 2, bitmap.getImage().getHeight() / 2, angle, scale, bitmap);
    }

    public void drawTransformedPicture(float posX, float posY, float angle, float width, float height, BitmapImage bitmap) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(bitmap.getRegion(), posX - width, posY - height, width, height, width * 2.0f, height * 2.0f, 1.0f, 1.0f, angle);
    }

    public void drawTransformedPicture(float posX, float posY, float centerX, float centerY, float angle, float scale, BitmapImage bitmap) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(bitmap.getRegion(), posX - (float)(bitmap.getRegion().getRegionWidth() / 2), posY - (float)(bitmap.getRegion().getRegionHeight() / 2), centerX, centerY, bitmap.getImage().getWidth(), bitmap.getImage().getHeight(), scale, scale, angle);
    }

    public void drawAlphaPicture(Vector2 pos, float alpha, BitmapImage img) {
        this.drawAlphaPicture(pos.x, pos.y, alpha, img);
    }

    public void drawAlphaPicture(float posX, float posY, float alpha, BitmapImage img) {
        this.drawAlphaPicture(posX, posY, 0.0f, 1.0f, alpha, img);
    }

    public void drawAlphaPicture(float posX, float posY, float angle, float scale, float alpha, BitmapImage img) {
        Color old = this.spriteBatch.getColor();
        this.spriteBatch.setColor(1.0f, 1.0f, 1.0f, alpha);
        this.drawTransformedPicture(posX, posY, angle, scale, img);
        this.spriteBatch.setColor(old);
    }

    public void drawPolygon(Polygon p) {
        this.checkMode(RenderingMode.SHAPE_LINE);
        this.shapeRenderer.identity();
        this.shapeRenderer.polygon(p.getVertices());
    }

    public void drawFilledPolygon(Polygon p, Color c) {
        float[] vertices = p.getEarClippedVertices();
        this.checkMode(RenderingMode.SHAPE_FILLED);
        this.shapeRenderer.setColor(c);
        this.shapeRenderer.identity();
        for (int i = 0; i < vertices.length; i += 6) {
            this.shapeRenderer.triangle(vertices[i], vertices[i + 1], vertices[i + 2], vertices[i + 3], vertices[i + 4], vertices[i + 5]);
        }
        this.shapeRenderer.setColor(this.currentColor);
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void moveCamera(float x, float y) {
        this.camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.camera.translate(x, y);
        this.cameraUpdated();
    }

    private Vector2 inside(Vector2 v, Vector2 p1, Vector2 p2) {
        return new Vector2(Math.min(Math.max(p1.x, v.x), p2.x), Math.min(Math.max(p1.y, v.y), p2.y));
    }

    public void moveCamera(float interest_x, float interest_y, float world_width, float world_height) {
        Vector2 camera_min = new Vector2(0.0f, 0.0f);
        Vector2 camera_max = new Vector2(world_width - (float)Gdx.graphics.getWidth() * this.camera.zoom, world_height - (float)Gdx.graphics.getHeight() * this.camera.zoom);
        Vector2 pos = new Vector2(interest_x, interest_y).sub((float)(Gdx.graphics.getWidth() / 2) * this.camera.zoom, (float)(Gdx.graphics.getHeight() / 2) * this.camera.zoom);
        pos = this.inside(pos, camera_min, camera_max);
        this.moveCamera(pos.x, pos.y);
    }

    public void resetCamera() {
        this.camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cameraUpdated();
    }

    public void scroll(float dx, float dy) {
        this.camera.translate(dx, dy);
        this.cameraUpdated();
    }

    public void zoom(float factor) {
        this.camera.zoom = factor;
        this.cameraUpdated();
    }

    private void cameraUpdated() {
        this.camera.update();
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
    }

    public void drawShader() {
        this.drawShader(this.getScreenWidth() / 2, this.getScreenHeight() / 2, 0.0f);
    }

    public void drawShader(float shaderTime) {
        this.drawShader(this.getScreenWidth() / 2, this.getScreenHeight() / 2, shaderTime);
    }

    public void drawShader(int posX, int posY, float shaderTime) {
        if (this.getShaderRenderer() != null) {
            this.getShaderRenderer().render(posX, posY, shaderTime);
        } else {
            try {
                throw new Exception("Shader renderer not set, aborting.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resetRenderingMode();
    }

    public void setShader(String s) {
        this.setShader(s, this.getScreenWidth(), this.getScreenHeight());
    }

    public void setShader(String s, int width, int height) {
        if (this.getShaderRenderer() != null) {
            this.getShaderRenderer().dispose();
        }
        this.setShaderRenderer(new ShaderRenderer(s, width, height));
    }

    public ShaderRenderer getShaderRenderer() {
        return this.shaderRenderer;
    }

    public void setShaderRenderer(ShaderRenderer shaderRenderer) {
        this.shaderRenderer = shaderRenderer;
    }

    public void setBlendFunction(int srcFunc, int dstFunc) {
        this.spriteBatch.setBlendFunction(srcFunc, dstFunc);
    }

    public void resetBlend() {
        this.setBlendFunction(770, 771);
    }

    public void draw(Texture texture, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y, originX, originY, width, height, scaleX, scaleY, rotation, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
    }

    public void draw(Texture texture, float x, float y, float width, float height, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y, width, height, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
    }

    public void draw(Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y, srcX, srcY, srcWidth, srcHeight);
    }

    public void draw(Texture texture, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y, width, height, u, v, u2, v2);
    }

    public void draw(Texture texture, float x, float y) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y);
    }

    public void draw(Texture texture, float x, float y, float width, float height) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, x, y, width, height);
    }

    public void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(texture, spriteVertices, offset, count);
    }

    public void draw(TextureRegion region, float x, float y) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(TextureRegion region, float x, float y, float width, float height) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(region, x, y, originX, originY, width, height, scaleX, scaleY, rotation);
    }

    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(region, x, y, originX, originY, width, height, scaleX, scaleY, rotation, clockwise);
    }

    public void draw(TextureRegion region, float width, float height, Affine2 transform) {
        this.checkMode(RenderingMode.SPRITE);
        this.spriteBatch.draw(region, width, height, transform);
    }

    public Color sbGetColor() {
        return this.spriteBatch.getColor();
    }

    public void sbSetColor(float r, float g, float b, float a) {
        this.spriteBatch.setColor(r, g, b, a);
    }

    public void sbSetColor(Color col) {
        this.spriteBatch.setColor(col);
    }

    public void sbFlush() {
        this.spriteBatch.flush();
    }

    public void beginCustomRendering() {
        this.checkMode(RenderingMode.NONE);
    }

    public void endCustomRendering() {
    }

    private static enum RenderingMode {
        NONE,
        SHAPE_FILLED,
        SHAPE_LINE,
        SHAPE_POINT,
        SPRITE;

    }
}

