/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib;

import ch.hevs.gdx2d.components.screen_management.RenderingScreen;
import ch.hevs.gdx2d.components.screen_management.transitions.ScreenTransition;
import ch.hevs.gdx2d.components.screen_management.transitions.SliceTransition;
import ch.hevs.gdx2d.components.screen_management.transitions.SlideTransition;
import ch.hevs.gdx2d.components.screen_management.transitions.SmoothTransition;
import ch.hevs.gdx2d.lib.GdxGraphics;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import java.util.ArrayList;

public class ScreenManager {
    protected ArrayList<Class> screens = new ArrayList();
    protected int activeScreen = 0;
    protected RenderingScreen currScreen;
    protected RenderingScreen nextScreen;
    protected TransactionType transitionStyle = TransactionType.SMOOTH;
    protected FrameBuffer currFbo;
    protected FrameBuffer nextFbo;
    protected SpriteBatch batch;
    protected float time;
    protected ScreenTransition screenTransition;
    protected boolean transitioning = false;
    protected int nextScreenIdx = -1;

    protected RenderingScreen createInstance(Class c) {
        try {
            RenderingScreen s = (RenderingScreen)c.newInstance();
            s.onInit();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void render(GdxGraphics g) {
        if (!this.transitioning) {
            this.currScreen.render(g);
        } else {
            if (this.screenTransition == null) {
                int w = g.getScreenWidth();
                int h = g.getScreenHeight();
                this.currFbo = new FrameBuffer(Pixmap.Format.RGB888, w, h, false);
                this.nextFbo = new FrameBuffer(Pixmap.Format.RGB888, w, h, false);
                this.batch = new SpriteBatch();
                switch (this.transitionStyle) {
                    case SLICE: {
                        this.screenTransition = SliceTransition.init(0.75f, 3, 10, Interpolation.pow4Out);
                        break;
                    }
                    case SLIDE: {
                        this.screenTransition = SlideTransition.init(0.75f, 1, false, Interpolation.bounceOut);
                        break;
                    }
                    case SMOOTH: {
                        this.screenTransition = SmoothTransition.init(0.75f);
                    }
                }
                this.currFbo.begin();
                this.currScreen.render(g);
                this.currFbo.end();
                this.currScreen.dispose();
                this.currScreen = null;
                this.nextScreen = this.createInstance(this.screens.get(this.getNextScreenIndex()));
                this.nextFbo.begin();
                this.nextScreen.render(g);
                this.nextFbo.end();
            }
            this.transition(Gdx.graphics.getDeltaTime());
        }
    }

    private void transition(float deltaTime) {
        float duration = this.screenTransition.getDuration();
        this.time = Math.min(this.time + deltaTime, duration);
        if (this.screenTransition == null || this.time >= duration) {
            this.screenTransition = null;
            this.transitioning = false;
            this.activeScreen = this.getNextScreenIndex();
            this.currScreen = this.nextScreen;
            this.nextScreen = null;
            this.time = 0.0f;
            return;
        }
        float alpha = this.time / duration;
        this.screenTransition.render(this.batch, this.currFbo.getColorBufferTexture(), this.nextFbo.getColorBufferTexture(), alpha);
    }

    private int getNextScreenIndex() {
        if (this.nextScreenIdx < 0) {
            return (this.activeScreen + 1) % this.screens.size();
        }
        return this.nextScreenIdx;
    }

    private int checkIndexBounds(int screenIndex) {
        if (screenIndex < 0) {
            return 0;
        }
        if (screenIndex > this.screens.size() - 1) {
            return this.screens.size() - 1;
        }
        return screenIndex;
    }

    public void registerScreen(Class s) {
        this.screens.add(s);
        if (this.currScreen == null) {
            this.currScreen = this.createInstance(this.screens.get(0));
        }
    }

    public void activateNextScreen() {
        if (!this.transitioning) {
            this.currScreen.dispose();
            this.nextScreenIdx = -1;
            this.activeScreen = this.getNextScreenIndex();
            this.currScreen = this.createInstance(this.screens.get(this.activeScreen));
        }
    }

    public void activateScreen(int nextScreen) {
        if (this.activeScreen == nextScreen) {
            return;
        }
        if (!this.transitioning) {
            this.currScreen.dispose();
            this.nextScreenIdx = -1;
            this.activeScreen = this.checkIndexBounds(nextScreen);
            this.currScreen = this.createInstance(this.screens.get(this.activeScreen));
        }
    }

    public void transitionToNext(TransactionType effect) {
        if (!this.transitioning) {
            this.transitioning = true;
            this.transitionStyle = effect;
        }
    }

    public void transitionTo(int nextScreen, TransactionType effect) {
        if (this.activeScreen == nextScreen) {
            return;
        }
        if (!this.transitioning) {
            this.nextScreenIdx = this.checkIndexBounds(nextScreen);
            this.transitioning = true;
            this.transitionStyle = effect;
        }
    }

    public void sliceTransitionToNext() {
        this.transitionToNext(TransactionType.SLICE);
    }

    public void slideTransitionToNext() {
        this.transitionToNext(TransactionType.SLIDE);
    }

    public void smoothTransitionToNext() {
        this.transitionToNext(TransactionType.SMOOTH);
    }

    public RenderingScreen getActiveScreen() {
        return !this.transitioning ? this.currScreen : null;
    }

    public static enum TransactionType {
        SMOOTH,
        SLIDE,
        SLICE;

    }
}

