/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib.physics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Vector;

public class PhysicsWorld {
    private static final Vector<Body> toRemove = new Vector();
    private static PhysicsWorld instance = null;
    private World w = new World(new Vector2(0.0f, -10.0f), true);
    private static float accumulator;
    private static float step;

    private PhysicsWorld() {
    }

    public static World getInstance() {
        if (instance == null) {
            instance = new PhysicsWorld();
        }
        return PhysicsWorld.instance.w;
    }

    public static void scheduleForDeletion(Body obj) {
        assert (obj != null);
        toRemove.add(obj);
    }

    public static void updatePhysics() {
        PhysicsWorld.updatePhysics(Gdx.graphics.getDeltaTime());
    }

    public static void updatePhysics(float dt) {
        if (instance == null) {
            PhysicsWorld.getInstance();
        }
        accumulator += dt;
        while (accumulator >= step) {
            PhysicsWorld.instance.w.step(step, 6, 5);
            accumulator -= step / 2.0f;
        }
        for (Body obj : toRemove) {
            assert (obj != null);
            obj.setUserData(null);
            PhysicsWorld.instance.w.destroyBody(obj);
        }
        toRemove.clear();
    }

    public static void dispose() {
        if (instance != null) {
            PhysicsWorld.instance.w.dispose();
            PhysicsWorld.instance.w = new World(new Vector2(0.0f, -10.0f), true);
        }
    }

    static {
        step = 0.016666668f;
    }
}

