/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib.renderers;

import ch.hevs.gdx2d.lib.utils.Logger;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class ShaderRenderer
implements Disposable {
    protected final String fragmentShaderInclude = Gdx.files.internal("res/lib/fragment_include.glsl").readString();
    protected ShaderProgram shader;
    protected Texture[] tex = new Texture[10];
    protected int textureCount = 0;
    protected SpriteBatch batch;
    protected int w;
    protected int h;
    protected FileHandle vertexShader;

    public ShaderRenderer(String shaderFileName, int width, int height) {
        this(Gdx.files.internal(shaderFileName), width, height);
    }

    ShaderRenderer(FileHandle handle, int width, int height) {
        this.w = width;
        this.h = height;
        this.vertexShader = Gdx.files.internal("res/lib/default.vs");
        Logger.dbg(String.format("Fragment shader '%s' loaded.", handle));
        Logger.dbg(String.format("Vertex shader '%s' loaded.", this.vertexShader));
        this.create(this.fragmentShaderInclude + handle.readString(), this.vertexShader.readString());
        String log = "Shader defined uniforms are :\n";
        for (String uniform : this.shader.getUniforms()) {
            log = log + "\t" + uniform + " = " + this.shader.getAttributeType(uniform) + "\n";
        }
        Logger.dbg(log);
        log = "Shader defined attributes are :\n";
        for (String a : this.shader.getAttributes()) {
            log = log + String.format("\t%s\n", a);
        }
        Logger.dbg(log);
        this.shader.begin();
        this.shader.setUniformf("resolution", (float)this.w, (float)this.h);
        this.shader.end();
    }

    private void create(String fragmentShader, String vertexShader) {
        this.tex[0] = new Texture(this.w, this.h, Pixmap.Format.RGBA8888);
        ShaderProgram.pedantic = false;
        this.shader = new ShaderProgram(vertexShader, fragmentShader);
        if (!this.shader.isCompiled()) {
            Logger.log("Shader compile msg - " + this.shader.getLog());
            Gdx.app.exit();
        }
        if (this.shader.getLog().length() != 0 && !this.shader.getLog().contains("No errors")) {
            Logger.log("Shader message - " + this.shader.getLog());
        }
        this.batch = new SpriteBatch(1, this.shader);
        this.batch.setShader(this.shader);
    }

    public void render(int posX, int posY, float time) {
        this.batch.begin();
        this.shader.setUniformf("time", time);
        this.batch.draw(this.tex[0], (float)(posX - this.w / 2), (float)(posY - this.h / 2));
        this.batch.end();
    }

    public void setUniform(String uniform, int value) {
        this.batch.begin();
        this.shader.setUniformi(uniform, value);
        this.batch.end();
    }

    public void setUniform(String uniform, boolean value) {
        this.batch.begin();
        this.shader.setUniformi(uniform, value ? 1 : 0);
        this.batch.end();
    }

    public void setUniform(String uniform, float value) {
        this.batch.begin();
        this.shader.setUniformf(uniform, value);
        this.batch.end();
    }

    public void setUniform(String uniform, float[] values) {
        this.batch.begin();
        this.shader.setUniform1fv(uniform, values, 0, values.length);
        this.batch.end();
    }

    public void setUniform(String uniform, Vector2 values) {
        this.batch.begin();
        this.shader.setUniformf(uniform, values);
        this.batch.end();
    }

    public void setUniform(String uniform, Vector3 values) {
        this.batch.begin();
        this.shader.setUniformf(uniform, values);
        this.batch.end();
    }

    public int addTexture(Texture t, String n) {
        try {
            if (this.textureCount >= 34018) {
                throw new Exception("Out of texture space!");
            }
            ++this.textureCount;
            this.tex[this.textureCount] = t;
            this.shader.begin();
            this.shader.setUniformi(n, this.textureCount);
            this.shader.end();
            Gdx.graphics.getGL20().glActiveTexture(33984 + this.textureCount);
            this.tex[this.textureCount].bind(this.textureCount);
            Gdx.graphics.getGL20().glActiveTexture(33984);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.textureCount;
    }

    public int addEmptyTexture(int width, int height, String textureIdentifier) {
        Texture t = new Texture(width, height, Pixmap.Format.RGBA8888);
        return this.addTexture(t, textureIdentifier);
    }

    public int addTexture(String texturePath, String textureIdentifier) {
        Texture t = new Texture(Gdx.files.internal(texturePath));
        return this.addTexture(t, textureIdentifier);
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.shader.dispose();
        for (int i = 0; i < this.textureCount; ++i) {
            this.tex[i].dispose();
        }
    }

    public void setTexture(Texture colorBufferTexture, int id) {
        this.tex[id] = colorBufferTexture;
    }
}

