/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.lib.utils.catmull;

import ch.hevs.gdx2d.lib.utils.catmull.CatmullRomSpline2D;
import com.badlogic.gdx.math.Vector2;

public class CatmullRomUtils {
    public static Vector2[] subdividePoints(Vector2[] points, int subdivisions) {
        assert (points != null);
        assert (points.length >= 3);
        Vector2[] subdividedPoints = new Vector2[(points.length - 1) * subdivisions + 1];
        float increments = 1.0f / (float)subdivisions;
        for (int i = 0; i < points.length - 1; ++i) {
            Vector2 p0 = i == 0 ? points[i] : points[i - 1];
            Vector2 p1 = points[i];
            Vector2 p2 = points[i + 1];
            Vector2 p3 = i + 2 == points.length ? points[i + 1] : points[i + 2];
            CatmullRomSpline2D crs = new CatmullRomSpline2D(p0, p1, p2, p3);
            for (int j = 0; j <= subdivisions; ++j) {
                subdividedPoints[i * subdivisions + j] = crs.q((float)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static void main(String[] args) {
        Vector2[] subdividedPoints;
        Vector2[] pointArray = new Vector2[]{new Vector2(1.0f, 1.0f), new Vector2(2.0f, 2.0f), new Vector2(3.0f, 2.0f), new Vector2(4.0f, 1.0f)};
        for (Vector2 point : subdividedPoints = CatmullRomUtils.subdividePoints(pointArray, 4)) {
            System.out.println("" + point);
        }
    }
}

