/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.physics;

import ch.hevs.gdx2d.components.physics.utils.PhysicsConstants;
import ch.hevs.gdx2d.lib.GdxGraphics;
import ch.hevs.gdx2d.lib.interfaces.DrawableObject;
import ch.hevs.gdx2d.lib.physics.PhysicsWorld;
import ch.hevs.gdx2d.lib.utils.catmull.CatmullRomUtils;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;

public class PhysicsChain
implements DrawableObject {
    protected Body b;
    protected ArrayList<Vector2> vertices;
    protected ChainShape s = new ChainShape();
    protected Vector2 start;
    protected Vector2 stop;
    final float M2P = PhysicsConstants.METERS_TO_PIXELS;

    public PhysicsChain(Vector2 start, Vector2 stop, int nPoints, chain_type t) {
        this.start = start;
        this.stop = stop;
        if (t == chain_type.RANDOM) {
            this.random_chain(nPoints);
        } else {
            this.catmull_chain(nPoints);
        }
    }

    public void random_chain(int nPoints) {
        World w = PhysicsWorld.getInstance();
        if (this.b != null) {
            w.destroyBody(this.b);
        }
        BodyDef bd = new BodyDef();
        this.b = w.createBody(bd);
        ChainShape s = new ChainShape();
        this.vertices = this.random_vertices(nPoints, 0.3f);
        s.createChain(this.vertices.toArray(new Vector2[0]));
        this.b.createFixture(s, 1.0f);
        s.dispose();
    }

    public void catmull_chain(int nPoints) {
        World w = PhysicsWorld.getInstance();
        if (this.b != null) {
            w.destroyBody(this.b);
        }
        BodyDef bd = new BodyDef();
        this.b = w.createBody(bd);
        ChainShape s = new ChainShape();
        this.vertices = this.random_vertices(nPoints, 0.8f);
        Vector2[] spline = CatmullRomUtils.subdividePoints(this.vertices.toArray(new Vector2[0]), 9);
        s.createChain(spline);
        this.b.createFixture(s, 1.0f);
        this.vertices.clear();
        for (int i = 0; i < spline.length; ++i) {
            this.vertices.add(spline[i]);
        }
        s.dispose();
    }

    private ArrayList<Vector2> random_vertices(int nPoints, float random_height) {
        ArrayList<Vector2> vertices = new ArrayList<Vector2>();
        float width = (this.stop.x - this.start.x) / (float)(nPoints - 1);
        float height = (this.stop.y - this.start.y) / (float)(nPoints - 1);
        for (int i = 0; i < nPoints; ++i) {
            float h = this.start.y + height * (float)i;
            h += (float)((double)random_height * (Math.random() * (double)h));
            Vector2 p = new Vector2(this.start.x + width * (float)i, h);
            vertices.add(PhysicsConstants.coordPixelsToMeters(p));
        }
        return vertices;
    }

    @Override
    public void draw(GdxGraphics g) {
        Vector2 first = this.vertices.get(0);
        g.setColor(Color.BLUE);
        g.setPenWidth(3.0f);
        for (int j = 1; j < this.vertices.size(); ++j) {
            Vector2 i = this.vertices.get(j);
            g.drawLine(first.x * this.M2P, first.y * this.M2P, i.x * this.M2P, i.y * this.M2P);
            first = i;
        }
        g.setPenWidth(1.0f);
    }

    public static enum chain_type {
        RANDOM,
        CATMUL;

    }
}

