/*
 * Decompiled with CFR 0.152.
 */
package ch.hevs.gdx2d.components.physics;

import ch.hevs.gdx2d.lib.physics.PhysicsWorld;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;

public class PhysicsMotor {
    Body body1;
    Body body2;
    Vector2 anchorPoint;
    RevoluteJointDef rjd;
    private RevoluteJoint joint;

    public PhysicsMotor(Body body1, Body body2, Vector2 anchorPoint, float motorSpeed, float maxMotorTorque, boolean motorEnable) {
        this.body1 = body1;
        this.body2 = body2;
        this.anchorPoint = anchorPoint;
        this.rjd = new RevoluteJointDef();
        this.rjd.initialize(this.body1, this.body2, anchorPoint);
        this.rjd.motorSpeed = motorSpeed;
        this.rjd.maxMotorTorque = maxMotorTorque;
        this.rjd.enableMotor = motorEnable;
        this.joint = (RevoluteJoint)PhysicsWorld.getInstance().createJoint(this.rjd);
    }

    public PhysicsMotor(Body body1, Body body2, Vector2 anchorPoint) {
        this.body1 = body1;
        this.body2 = body2;
        this.anchorPoint = anchorPoint;
        this.rjd = new RevoluteJointDef();
        this.rjd.initialize(this.body1, this.body2, anchorPoint);
        this.rjd.motorSpeed = 0.0f;
        this.rjd.maxMotorTorque = 0.0f;
        this.rjd.enableMotor = false;
        this.joint = (RevoluteJoint)PhysicsWorld.getInstance().createJoint(this.rjd);
    }

    public void enableLimit(boolean flag) {
        this.joint.enableLimit(flag);
    }

    public void enableMotor(boolean flag) {
        this.joint.enableMotor(flag);
    }

    public float getAngle() {
        return this.joint.getJointAngle();
    }

    public float getSpeed() {
        return this.joint.getJointSpeed();
    }

    public Vector2 getLocalAnchorA() {
        return this.joint.getAnchorA();
    }

    public Vector2 getLocalAnchorB() {
        return this.joint.getAnchorB();
    }

    public float getLowerLimit() {
        return this.joint.getLowerLimit();
    }

    public float getMotorSpeed() {
        return this.joint.getMotorSpeed();
    }

    public float getMaxMotortorque(float invDt) {
        return this.joint.getMotorTorque(invDt);
    }

    public float getUpperLimit() {
        return this.joint.getUpperLimit();
    }

    public boolean isLimitEnabled() {
        return this.joint.isLimitEnabled();
    }

    public boolean isMotorEnabled() {
        return this.joint.isMotorEnabled();
    }

    public void setLowerLimit(float lower) {
        this.joint.setLimits(lower, this.joint.getUpperLimit());
    }

    public void setUpperLimit(float upper) {
        this.joint.setLimits(this.joint.getLowerLimit(), upper);
    }

    public void setLimits(float lower, float upper) {
        this.joint.setLimits(lower, upper);
    }

    public void setMaxMotorTorque(float torque) {
        this.joint.setMaxMotorTorque(torque);
    }

    public void setMotorSpeed(float speed) {
        this.joint.setMotorSpeed(speed);
    }

    public void initializeMotor(float speed, float torque, boolean enable) {
        this.joint.setMotorSpeed(speed);
        this.joint.setMaxMotorTorque(torque);
        this.joint.enableMotor(enable);
    }

    public RevoluteJoint getJoint() {
        return this.joint;
    }
}

