package ch.hevs.medgift.plugins.common.helpers;

import ch.hevs.medgift.plugins.common.models.ChartConfig;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

public class ChartConfigAdapterFactory implements TypeAdapterFactory {
    private final Class<? extends ChartConfig> implementationClass;

    public ChartConfigAdapterFactory(Class<? extends ChartConfig> implementationClass) {
        this.implementationClass = implementationClass;
    }

    @SuppressWarnings("unchecked")
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    	
    	TypeAdapter<T> adapter;
    	
    	if (!ChartConfig.class.equals(type.getRawType()))
        	adapter = null;
        else
        	adapter = (TypeAdapter<T>) gson.getAdapter(implementationClass);

        return adapter;
    }
}