package ch.hevs.medgift.plugins.common.models;

import java.util.List;

import com.google.gson.annotations.SerializedName;

public class ChartConfigImpl implements ChartConfig {
	private String chartType;
	
	@SerializedName(value="chartTitle", alternate={"title"})
	private String chartTitle;
	
	@SerializedName(value="xAxisTitle", alternate={"xAxis"})
	private String xAxisTitle;
	
	@SerializedName(value="xAxisLabels", alternate={"xTickLabels"})
	private List<String> xAxisLabels;
	
	@SerializedName(value="yAxisTitle", alternate={"yAxis"})
	private String yAxisTitle;
	
	private String yAxisType;
	private Double yAxisMin;
	private Double yAxisMax;
	private Double yAxisTickInterval;
	private Boolean yAxisIsPercentage;
	
	public ChartConfigImpl(){};
	
	public ChartConfigImpl(String chartType, String chartTitle, String xAxisTitle, String yAxisTitle,
			List<String> xAxisLabels, String yAxisType, Double yAxisMin, Double yAxisMax, Double yAxisTickInterval, Boolean yAxisIsPercentage) {
		super();
		this.chartType = chartType;
		this.chartTitle = chartTitle;
		this.xAxisTitle = xAxisTitle;
		this.yAxisTitle = yAxisTitle;		
		this.xAxisLabels = xAxisLabels;
		this.yAxisType = yAxisType;
		this.yAxisMin = yAxisMin;
		this.yAxisMax = yAxisMax;
		this.yAxisTickInterval = yAxisTickInterval;
		this.yAxisIsPercentage = yAxisIsPercentage;
	}
	
	public ChartConfigImpl(String chartType, String chartTitle, String xAxisTitle, String yAxisTitle, List<String> xAxisLabels, String yAxisType){
		this(chartType, chartTitle, xAxisTitle, yAxisTitle, xAxisLabels, yAxisType, null, null, null, null);
	}
	
	public ChartConfigImpl(String chartType, String chartTitle, String xAxisTitle, String yAxisTitle, List<String> xAxisLabels){
		this(chartType, chartTitle, xAxisTitle, yAxisTitle, xAxisLabels, null, null, null, null, null);
	}
	
	public ChartConfigImpl(String chartType, String chartTitle, String xAxisTitle, String yAxisTitle){
		this(chartType, chartTitle, xAxisTitle, yAxisTitle, null, null, null, null, null, null);
	}
	
	public ChartConfigImpl(String chartType, String chartTitle){
		this(chartType, chartTitle, null, null, null, null, null, null, null, null);
	}
	
	public ChartConfigImpl(String chartType){
		this(chartType, null);
	}
	
	
	public String getChartType() {
		return chartType;
	}
	public void setChartType(String chartType) {
		this.chartType = chartType;
	}
	public String getChartTitle() {
		return chartTitle;
	}
	public void setChartTitle(String chartTitle) {
		this.chartTitle = chartTitle;
	}
	public String getxAxisTitle() {
		return xAxisTitle;
	}
	public void setxAxisTitle(String xAxisTitle) {
		this.xAxisTitle = xAxisTitle;
	}
	public List<String> getxAxisLabels() {
		return xAxisLabels;
	}
	public void setxAxisLabels(List<String> xAxisLabels) {
		this.xAxisLabels = xAxisLabels;
	}
	public String getyAxisTitle() {
		return yAxisTitle;
	}
	public void setyAxisTitle(String yAxisTitle) {
		this.yAxisTitle = yAxisTitle;
	}
	public String getyAxisType() {
		return yAxisType;
	}
	public void setyAxisType(String yAxisType) {
		this.yAxisType = yAxisType;
	}

	public Double getyAxisMin() {
		return yAxisMin;
	}

	public void setyAxisMin(Double yAxisMin) {
		this.yAxisMin = yAxisMin;
	}

	public Double getyAxisMax() {
		return yAxisMax;
	}

	public void setyAxisMax(Double yAxisMax) {
		this.yAxisMax = yAxisMax;
	}

	public Double getyAxisTickInterval() {
		return yAxisTickInterval;
	}

	public void setyAxisTickInterval(Double yAxisTickInterval) {
		this.yAxisTickInterval = yAxisTickInterval;
	}

	public Boolean getyAxisIsPercentage() {
		return yAxisIsPercentage;
	}

	public void setyAxisIsPercentage(Boolean yAxisIsPercentage) {
		this.yAxisIsPercentage = yAxisIsPercentage;
	}
	
}
