package ch.hevs.medgift.plugins.common.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import ch.hevs.medgift.plugins.common.helpers.GsonIgnore;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Entity
@Table(name="ImageAnnotation")
public class ImageAnnotation implements Serializable{

	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	@GsonIgnore
	private int id;
	
	@Column(name ="EpadId")
	private String epadId;
	
	@Column(name ="Name")
	private String name;
	
	@Column(name ="DateTime")
	private String datetime;
	
	@Column(name ="Comment")
	private String comment;
	
	@Column(name ="Label")
	private String label; //Ex: Normal, AbNormal
	
	//MarkupEntityCollection - PolygonEntity
	@Column(name ="Coordinates")
	private double[][] coordinates;
	
	//imageReferenceEntityCollection
	@ManyToOne
	private ImageReferenceEntity imageReference;
	
	@OneToMany(mappedBy="imageAnnotation", cascade = CascadeType.ALL)
	@GsonIgnore
	private List<QuantitativeImagingFeatures> quantitativeImagingFeatures;
	
	public ImageAnnotation() {
		this.quantitativeImagingFeatures = new ArrayList<QuantitativeImagingFeatures>();
	}
	
	
	public ImageAnnotation(String epadId, String name, String datetime, String comment,
			double[][] coordinates, ImageReferenceEntity imageReference) {
		super();
		this.epadId = epadId;
		this.name = name;
		this.datetime = datetime;
		this.comment = comment;
		this.coordinates = coordinates;
		this.imageReference = imageReference;		
		this.imageReference.addAnnotation(this);
		this.quantitativeImagingFeatures = new ArrayList<QuantitativeImagingFeatures>();
	}


	public String getEpadId() {
		return epadId;
	}


	public void setEpadId(String epadId) {
		this.epadId = epadId;
	}


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDatetime() {
		return datetime;
	}

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public double[][] getCoordinates() {
		return coordinates;
	}

	public void setCoordinates(double[][] coordinates) {
		this.coordinates = coordinates;
	}

	public ImageReferenceEntity getImageReference() {
		return imageReference;
	}

	public void setImageReference(ImageReferenceEntity imageReference) {
		this.imageReference = imageReference;
		this.imageReference.addAnnotation(this);
	}

	public int getId() {
		return id;
	}


	public String getLabel() {
		return label;
	}


	public void setLabel(String label) {
		this.label = label;
	}


	public List<QuantitativeImagingFeatures> getQuantitativeImagingFeatures() {
		return quantitativeImagingFeatures;
	}


	public void setQuantitativeImagingFeatures(
			List<QuantitativeImagingFeatures> quantitativeImagingFeatures) {
		this.quantitativeImagingFeatures = quantitativeImagingFeatures;
	}
	
	public void addQuantitativeImagingFeatures(QuantitativeImagingFeatures features){
		this.quantitativeImagingFeatures.add(features);
	}
	
}
