package ch.hevs.medgift.plugins.common.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import ch.hevs.medgift.plugins.common.helpers.GsonIgnore;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Entity
@Table(name="Image")
public class ImageReferenceEntity implements Serializable{

	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	@GsonIgnore
	private int id;
	
	@Column(name ="SopInstanceUid")
	private String sopInstanceUid;
	
	@Column(name ="ImageMatrix")
	private float[][] imageMatrix;
	
	@ManyToOne(cascade = CascadeType.PERSIST)
	private Patient patient;
	
	@OneToMany(mappedBy="imageReference", cascade = CascadeType.ALL)
	@GsonIgnore
	private List<ImageAnnotation> annotations;
	
	public ImageReferenceEntity() {
		this.annotations = new ArrayList<ImageAnnotation>();
	}	
	
	public ImageReferenceEntity(String sopInstanceUid, float[][] imageMatrix,
			Patient patient) {
		super();
		this.sopInstanceUid = sopInstanceUid;
		this.imageMatrix = imageMatrix;
		this.patient = patient;
		this.annotations = new ArrayList<ImageAnnotation>();
		
		patient.addImage(this);
	}



	public int getId() {
		return id;
	}

	public float[][] getImageMatrix() {
		return imageMatrix;
	}

	public void setImageMatrix(float[][] imageMatrix) {
		this.imageMatrix = imageMatrix;
	}
	
	public void addAnnotation(ImageAnnotation annotation){
		this.annotations.add(annotation);
	}



	public String getSopInstanceUid() {
		return sopInstanceUid;
	}



	public void setSopInstanceUid(String sopInstanceUid) {
		this.sopInstanceUid = sopInstanceUid;
	}



	public Patient getPatient() {
		return patient;
	}



	public void setPatient(Patient patient) {
		this.patient = patient;
	}



	public List<ImageAnnotation> getAnnotations() {
		return annotations;
	}



	public void setAnnotations(List<ImageAnnotation> annotations) {
		this.annotations = annotations;
	}
	
	
}
