
package ch.hevs.medgift.plugins.common.models;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.*;

import ch.hevs.medgift.plugins.common.helpers.GsonIgnore;

/**
 * The persistent class for the person database table.
 * 
 * @author Himmouche Abderrahmane
 */

@Entity
@Table(name="Patient")
public class Patient extends Person{
	
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	@GsonIgnore
	private int id;
	
	@Column(name ="EpadId")
	private String epadId;
	
	@Column(name ="Birthdate")
	private String birthdate;
	
	@Column(name ="Sex")
	private String sex;
	
	@Column(name ="EthnicGroup")
	private String ethnicGroupe;
	
	@OneToMany(mappedBy="patient", cascade = CascadeType.ALL)
	@GsonIgnore
	private List<ImageReferenceEntity> images;

	public Patient() {
		this.images = new ArrayList<ImageReferenceEntity>();
	}	

	public Patient(String epadId, String name, String birthdate, String sex, String ethnicGroupe) {
		super();
		this.epadId = epadId;
		this.setName(name);
		this.birthdate = birthdate;
		this.sex = sex;
		this.ethnicGroupe = ethnicGroupe;
		this.images = new ArrayList<ImageReferenceEntity>();
	}

	public String getEpadId() {
		return epadId;
	}

	public void setEpadId(String epadId) {
		this.epadId = epadId;
	}

	public String getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(String birthdate) {
		this.birthdate = birthdate;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getEthnicGroupe() {
		return ethnicGroupe;
	}

	public void setEthnicGroupe(String ethnicGroupe) {
		this.ethnicGroupe = ethnicGroupe;
	}

	public void addImage(ImageReferenceEntity image){
		images.add(image);
	}

	public List<ImageReferenceEntity> getImages() {
		return images;
	}

	public void setImages(List<ImageReferenceEntity> images) {
		this.images = images;
	}
	
}