package ch.hevs.medgift.plugins.common.models;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import ch.hevs.medgift.plugins.common.helpers.GsonIgnore;

import com.google.gson.annotations.SerializedName;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class Person implements Serializable{
	
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	@GsonIgnore
	@SerializedName("personId")
	private int id;

	@Column(name ="Name")
	private String name;

	
	
	public Person() {
		super();
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	
}
