package ch.hevs.medgift.plugins.common.models;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Entity
@Table(name="QuantitativeFeatures")
public class QuantitativeImagingFeatures implements Serializable{

	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	private int id;
	
	@Column(name ="ProjectId")
	private String projectId;
	
	@Column(name = "ModelFileName")
	private String modelFileName;
	
	@Column(name ="FeatureType")
	private String featureType;
	
	@Column(name ="FeatureValues")
	private double [] featureValues;
	
	@ManyToOne (fetch = FetchType.LAZY)
	private ImageAnnotation imageAnnotation;

	public QuantitativeImagingFeatures() {
		
	}

	public QuantitativeImagingFeatures(String featureType,
			double[] featureValues, ImageAnnotation imageAnnotation) {
		super();
		this.featureType = featureType;
		this.featureValues = featureValues;
		this.imageAnnotation = imageAnnotation;
	}

	public String getFeatureType() {
		return featureType;
	}

	public void setFeatureType(String featureType) {
		this.featureType = featureType;
	}

	public double[] getFeatureValues() {
		return featureValues;
	}

	public void setFeatureValues(double[] featureValues) {
		this.featureValues = featureValues;
	}

	public ImageAnnotation getImageAnnotation() {
		return imageAnnotation;
	}

	public void setImageAnnotation(ImageAnnotation imageAnnotation) {
		this.imageAnnotation = imageAnnotation;
		this.imageAnnotation.addQuantitativeImagingFeatures(this);
	}

	public int getId() {
		return id;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getModelFileName() {
		return modelFileName;
	}

	public void setModelFileName(String modelFileName) {
		this.modelFileName = modelFileName;
	}
	
}
