package ch.hevs.medgift.plugins.common.models;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import ch.hevs.medgift.plugins.common.helpers.GsonIgnore;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Entity
@Table(name="User")
public class User extends Person{

	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name ="Id")
	@GsonIgnore
	private int id;
	
	@Column(name ="LoginName")
	private String loginName;
	
	@Column(name ="RoleInTrial")
	private String roleInTrial;

	public User() {
		super();
		
	}
	
	
	public User(String name, String loginName, String roleInTrial) {
		super();
		this.setName(name); 
		this.loginName = loginName;
		this.roleInTrial = roleInTrial;
	}



	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	public String getRoleInTrial() {
		return roleInTrial;
	}

	public void setRoleInTrial(String roleInTrial) {
		this.roleInTrial = roleInTrial;
	}
	
	
	
}
