package ch.hevs.medgift.epad.plugins.configuration;

import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;

import java.io.File;
import java.util.Iterator;

/**
 * Created by sro on 30/11/15.
 */
public class Configuration {

    private Configurations configs = new Configurations();

    private org.apache.commons.configuration2.Configuration config;

    private static final String DEFAULT_PROPERTIES_FILE_PATH = "default.properties";
    private static final String CUSTOM_PROPERTIES_FILE_PATH = "~/epad/DicomProxy/etc/medgift.custom.properties";
    private static final String CUSTOM_PROPERTIES_FILE_PATH_ALT = "~/DicomProxy/etc/medgift.custom.properties";

    public Configuration(){
        Parameters params = new Parameters();

        FileBasedConfigurationBuilder<org.apache.commons.configuration2.FileBasedConfiguration> builderDefaults =
                new FileBasedConfigurationBuilder<org.apache.commons.configuration2.FileBasedConfiguration>(PropertiesConfiguration.class)
                .configure(
                        params.properties().setFile(new File(this.getClass().getClassLoader().getResource(DEFAULT_PROPERTIES_FILE_PATH).getFile()))
                );

        File customPropsFile = new File(CUSTOM_PROPERTIES_FILE_PATH.replaceFirst("^~", System.getProperty("user.home")));
        if(!customPropsFile.exists())
            customPropsFile = new File(CUSTOM_PROPERTIES_FILE_PATH_ALT.replaceFirst("^~", System.getProperty("user.home")));

        FileBasedConfigurationBuilder<org.apache.commons.configuration2.FileBasedConfiguration> builderOther =
                new FileBasedConfigurationBuilder<org.apache.commons.configuration2.FileBasedConfiguration>(PropertiesConfiguration.class)
                        .configure(params.properties()
                                .setFile(customPropsFile));

        CompositeConfiguration cc = new CompositeConfiguration();
        try {
            cc.addConfiguration(builderOther.getConfiguration());
        }catch (ConfigurationException cex){
            System.err.println("No custom properties file found!");
        }

        try {
            cc.addConfiguration(builderDefaults.getConfiguration());
        }catch (ConfigurationException cex2){
            cex2.printStackTrace();
        }


        System.out.println("Using properties:");
        Iterator<String> it = cc.getKeys();
        while(it.hasNext()){
            String key = it.next();
            System.out.println(key + " : " + cc.getProperty(key));
        }

        this.config = cc;
    }

    public String getString(String propName){
        return this.config.getString(propName);
    }

    public int getInt(String propName){
        return this.config.getInt(propName);
    }

    public org.apache.commons.configuration2.Configuration getConfig(){
        return this.config;
    }
}
