package ch.hevs.medgift.epad.plugins.webservice.clients;

import ch.hevs.medgift.epad.plugins.configuration.Configuration;
import ch.hevs.medgift.plugins.common.helpers.ChartConfigAdapterFactory;
import ch.hevs.medgift.plugins.common.helpers.GsonExclusionStrategy;
import ch.hevs.medgift.plugins.common.models.*;
import com.google.gson.*;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import javafx.scene.chart.Chart;

import javax.ws.rs.core.MediaType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/**
 * Created by roger on 12.09.16.
 */
public class EpadWSClient {

    private WebResource webResource;
    private Client client;
    private static final String CONTEXT_ROOT = "epad-medgift-ws";
    private static final String WS_RESOURCES_ROOT = "epadwebservice";
    private static String BASE_URI;

    private static final Type STRING_ARRAY_TYPE = new TypeToken<String[]>() {}.getType();

    private Gson gson;

    private Configuration config;

    public EpadWSClient() {

        config = new Configuration();
        BASE_URI = config.getString("ws.protocol") + "://" + config.getString("ws.server") + "/" + CONTEXT_ROOT + "/" + WS_RESOURCES_ROOT;

        ClientConfig cc = new DefaultClientConfig();
        cc.getProperties().put(ClientConfig.PROPERTY_CONNECT_TIMEOUT, config.getInt("client.timeout"));
        cc.getProperties().put(ClientConfig.PROPERTY_READ_TIMEOUT, config.getInt("client.timeout"));

        GsonBuilder builder = new GsonBuilder();
        builder
                .setExclusionStrategies(new GsonExclusionStrategy())
                .registerTypeAdapterFactory(new ChartConfigAdapterFactory(ChartConfigImpl.class));
        gson = builder.create();

        System.out.println("Using server URL: " + BASE_URI);

        // SSL configuration
        /*if (!Configuration.SERVICE_PROTOCOL.equalsIgnoreCase("https")) {
          client = ClientBuilder.newClient(cc);
        } else {
          client = ClientBuilder.newBuilder()
                  .sslContext(SSLUtils.getSSLContext())
                  .hostnameVerifier(SSLUtils.getHostnameVerifier())
                  .withConfig(cc)
                  .build();
        }*/

        client = Client.create(cc);

        //Authentication
        //HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic(Configuration.WS_USER, Configuration.WS_PASS);
        //client.register(feature);

        webResource = client.resource(BASE_URI);
    }

    public EpadAnalysisResponse extractFeatures(EpadAnalysisPost data) {

        webResource = webResource.path("extractfeatures");
        // Post method
        ClientResponse response = webResource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, gson.toJson(data));

        // check response status code
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : "
                    + response.getStatus() + "\nWith URL : " + BASE_URI);
        }

        // Return response
        String output = response.getEntity(String.class);

        EpadAnalysisResponse analysisResponse = gson.fromJson(output, EpadAnalysisResponse.class);
        return analysisResponse;

    }

    public EpadTrainResponse trainModel(EpadTrainPost data){

        webResource = webResource.path("train");

        // Post method
        ClientResponse response = webResource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, gson.toJson(data));

        // check response status code
        if (response.getStatus() != 200){
            throw new RuntimeException("Failed : HTTP error code :  " + response.getStatus());
        }

        // Return response
        String output = response.getEntity(String.class);

        EpadTrainResponse trainResponse = gson.fromJson(output, EpadTrainResponse.class);
        return trainResponse;

    }

    public Map<String, EpadClassificationResponse> classify(EpadClassificationPost data){
        webResource = webResource.path("classify");
        // Post method
        ClientResponse response = webResource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, gson.toJson(data));

        // check response status code
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : "
                    + response.getStatus());
        }
        // Return response
        String output = response.getEntity(String.class);

        Type classificationResponseMapType = new TypeToken<Map<String, EpadClassificationResponse>>(){}.getType();

        Map<String, EpadClassificationResponse> classificationResponse = gson.fromJson(output, classificationResponseMapType);
        return classificationResponse;
    }

    public boolean deleteTrainingModelFeatures(String modelFileName){
        webResource = webResource.path("deleteTrainingModelFeatures");

        //Post method
        ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, modelFileName);

        String output = response.getEntity(String.class);
        boolean success = Boolean.valueOf(output);
        return success;
    }

    public String[] segmentLung(EpadSegmentationPost data){
        webResource = webResource.path("segmentLung");

        // Post method
        ClientResponse response = webResource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, gson.toJson(data));

        // check response status code
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : "
                    + response.getStatus());
        }

        // Return response
        String output = response.getEntity(String.class);
        String[] outputPaths = gson.fromJson(output, STRING_ARRAY_TYPE);
        return outputPaths;
    }

    public String[] segmentILD(EpadSegmentationPost data){
        webResource = webResource.path("segmentILD");

        // Post method
        ClientResponse response = webResource
                .accept(MediaType.APPLICATION_JSON)
                .type(MediaType.APPLICATION_JSON)
                .post(ClientResponse.class, gson.toJson(data));

        // check response status code
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : "
                    + response.getStatus());
        }

        // Return response
        String output = response.getEntity(String.class);
        String[] outputPaths = gson.fromJson(output, STRING_ARRAY_TYPE);
        return outputPaths;
    }
}
