package ch.hevs.medgift.epad.plugins.service;


import javax.ejb.EJB;
import javax.ejb.Stateless;

import ch.hevs.medgift.epad.plugins.qi.featureextraction.QIFeatureExtraction;
import ch.hevs.medgift.plugins.common.helpers.ChartConfigAdapterFactory;
import ch.hevs.medgift.plugins.common.models.*;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mathworks.toolbox.javabuilder.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/**
 * Session Bean implementation class MatlabBean
 * 
 * @author Himmouche Abderrahmane
 */
@Stateless
public class MatlabBean implements MatlabBeanLocal {

	@EJB
	MatlabFactory matlabFactory;
	@EJB
	PersistenceBeanLocal persist;
	@EJB
	SVMClassifierBeanLocal svm;

	/**
	 * Default constructor.
	 */
	public MatlabBean() {
	}
	
	
	/**
	 * Used to extract ROI features, persist data and update model
	 * 
	 * @param epadObj : DICOM data received from ePAD
	 * @return GSON object including analysis features
	 */
	public String extractFeatures(EpadAnalysisPost epadObj) {

        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new ChartConfigAdapterFactory(ChartConfigImpl.class));
        Gson gson = builder.create();

		// Features analysis
		EpadAnalysisResponse epadResponse = new EpadAnalysisResponse();
		epadResponse.setFeatureType(epadObj.getFeatureType());
		
		try {

			System.out.println("Using FeatureType : " + epadObj.getFeatureType());
			System.out.println("Using FeatureParams : " + epadObj.getFeatureParams());
            System.out.println("Trying to get feature extraction : " + matlabFactory.getFeatureextraction());
            QIFeatureExtraction featureExtraction = matlabFactory.getFeatureextraction();

			System.out.println("Extracting features : " + epadResponse.getFeatureType());
			Object[] response = featureExtraction.qi_featureExtraction(2,
					epadObj.getImage_matrix(), epadObj.getAnnotation_coordinates(), epadObj.getFeatureType(), epadObj.getFeatureParams());
			
			MWNumericArray featuresArray = (MWNumericArray) response[0];
            String chartConfig = ((MWCharArray) response[1]).toString();

			double[][] features = (double[][]) featuresArray.toDoubleArray();
            ChartConfig chartConfiguration = gson.fromJson(chartConfig, ChartConfig.class);

			System.out.println("Returning features from MATLAB, length : " + features.length + "x" + features[0].length);
			System.out.println("Returning chart config from MATLAB : " + chartConfiguration.toString());

			for(double[] featureVector : features){
				epadResponse.getQuantitativeImagingFeatures().add(featureVector);
			}

            epadResponse.setChartConfiguration(chartConfiguration);

			//Here we can add more analysis records when a ROI contains patchs
			
			//Persist All Data
			persist.persistAllDataWithoutPatchs(epadObj, epadResponse);
			
			//Update model 
			//svm.createUpdateModel(epadObj.getProject_id());
			
			return gson.toJson(epadResponse);
		} catch (Exception ex) {
			// Logger.getLogger(FeatureExtractionResource.class.getName()).log(Level.SEVERE,
			// null, ex);
			ex.printStackTrace();
		}

		return null;
	}
	/**
	 * Used to classify a ROI
	 * 
	 * @param epadObj : DICOM data received from ePAD
	 * @return Array object including analysis features
	 */
	public double[] extractClassificationFeatures(EpadAnalysisPost epadObj) {
		
		try {
			Object[] response = matlabFactory.getFeatureextraction().qi_featureExtraction(1,
					epadObj.getImage_matrix(), epadObj.getAnnotation_coordinates(), epadObj.getFeatureType(), epadObj.getFeatureParams());
			
			MWNumericArray featuresArray = (MWNumericArray) response[0];
			
			double[] features = featuresArray.getDoubleData();
			
			return features;
		} catch (Exception ex) {
			// Logger.getLogger(FeatureExtractionResource.class.getName()).log(Level.SEVERE,
			// null, ex);
			ex.printStackTrace();
		}

		return null;
	}

	/**
	 * Used to segment lungs
	 *
	 * @param epadObj : DICOM data received from ePAD (list of DICOM paths)
	 * @return Array object including output paths
	 */
	public String segmentLung(EpadSegmentationPost epadObj){
		try {

			List<String> dicomPathList = epadObj.getDicomPaths();

			MWCellArray dicomImageFilesPathCells = new MWCellArray(dicomPathList.size(), 1);
			int k = 1;
			for(String dicomPath : dicomPathList){
				MWCharArray path = new MWCharArray(dicomPath);
				dicomImageFilesPathCells.set(k++, path);
			}

			Object[] response = matlabFactory.getLungSegmentation().qi_Lung_segmentation(1, dicomImageFilesPathCells);
			MWCellArray maskImageFilesPathCells = (MWCellArray) response[0];

			List<Object> maskImageFilesPathObject = maskImageFilesPathCells.exportCells();

			List<String> maskImageFilesPathString = new ArrayList<>(maskImageFilesPathObject.size());
			for(int i = 0; i < maskImageFilesPathObject.size(); i++){
				maskImageFilesPathString.add(String.copyValueOf(((char[][]) (maskImageFilesPathObject.get(i)))[0]));
			}

			return new Gson().toJson(maskImageFilesPathString);
		} catch (Exception ex) {
			// Logger.getLogger(FeatureExtractionResource.class.getName()).log(Level.SEVERE,
			// null, ex);
			ex.printStackTrace();
		}

		return null;
	}

	@Override
	public String testMCR() throws MWException {
		Gson gson = new Gson();

		double[][] randomImage = randomMatrix(512);
		double[][] maskOfOnes = matrixOfOnes(512);

		String randomImageJSON = gson.toJson(randomImage);
		String randomMaskJSON = gson.toJson(maskOfOnes);

		QIFeatureExtraction fe = new QIFeatureExtraction();

		Object[] result = fe.qi_featureExtraction(1, randomImage, maskOfOnes, "Statistics");

		MWNumericArray features = ((MWNumericArray) result[0]);

		double[] array = features.getDoubleData();

		return Arrays.toString(array);
	}

	/* Utility methods */
	private double[][] randomMatrix(int n) {
		double[][] randomMatrix = new double[n][n];

		Random rand = new Random();
		rand.setSeed(System.currentTimeMillis());
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				Integer r = rand.nextInt() % 100;
				randomMatrix[i][j] = Math.abs(r);
			}

		}

		return randomMatrix;
	}

	private double[][] matrixOfOnes(int n){
		double[][] matrixOfOnes = new double[n][n];
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				matrixOfOnes[i][j] = 1;
			}

		}

		return matrixOfOnes;
	}
}
