
package ch.hevs.medgift.epad.plugins.service;

import javax.annotation.PostConstruct;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;

import ch.hevs.medgift.epad.plugins.qi.lungsegmentation.QILungSegmentation;
import com.mathworks.toolbox.javabuilder.MWException;

import ch.hevs.medgift.epad.plugins.qi.featureextraction.QIFeatureExtraction;
import com.sun.org.apache.xpath.internal.SourceTree;
import sun.net.NetProperties;

/**
 * Images processing algorithms
 * 
 * @author Himmouche Abderrahmane
 *
 */
//@Startup
@Singleton
@Lock(LockType.READ) //The class can be concurrently accessed and shared by many clients
public class MatlabFactory {

	private QIFeatureExtraction featureextraction;
	private QILungSegmentation lungSegmentation;
	private String status;

	@PostConstruct
	public void init(){
		try {
			System.out.println("INITIATING MATLAB FACTORY");
		} catch (Throwable e) {
			System.out.println("Cause: " + e.getCause());
			System.out.println("Message: " + e.getMessage());
			System.out.println("Class: " + e.getClass());
			System.out.println("StackTrace: " + e.getStackTrace());
		}
	}
	
	public QIFeatureExtraction getFeatureextraction() {
		if(featureextraction == null)
			try {
				featureextraction = new QIFeatureExtraction();
			}catch(MWException e){
				e.printStackTrace();
			}

		return featureextraction;
	}

	public QILungSegmentation getLungSegmentation() {
		if(lungSegmentation == null)
			try {
				lungSegmentation = new QILungSegmentation();
			}catch (MWException e){
				e.printStackTrace();
			}

		return lungSegmentation;
	}
}
