package ch.hevs.medgift.epad.plugins.service;

import ch.hevs.medgift.plugins.common.models.*;

import java.util.List;

import javax.ejb.Local;

/**
 * @author Himmouche Abderrahmane
 *
 */
@Local
public interface PersistenceBeanLocal {
	
	public void savePatient(Patient patient);
	public boolean checkPatient(String epadId);
	public Patient findPatient(Patient patient);
	public void saveImage(ImageReferenceEntity image);
	public boolean checkImage(String sopInstanceUid);
	public ImageReferenceEntity findImage(ImageReferenceEntity image);
	public void saveUser(User user);
	public boolean checkUser(String loginName);
	public User findUser(User user);
	public void saveAnnotation(ImageAnnotation annotation);
	public boolean checkAnnotation(String epadId);
	public ImageAnnotation findAnnotation(ImageAnnotation annotation);
	public void saveQuantitativeImagingFeatures(QuantitativeImagingFeatures features);
	public List<QuantitativeImagingFeatures> getAnalysisResults(String project_id);
	public List<QuantitativeImagingFeatures> getAnalysisResultsForModel(String modelFileName);
	public QuantitativeImagingFeatures findAnalysis(QuantitativeImagingFeatures feature, int annotation);
	public void persistAllDataWithoutPatchs(EpadAnalysisPost epadPost, EpadAnalysisResponse epadResponse);
	public boolean deleteTrainingModelFeatures(String modelFileName);
	
}
