package ch.hevs.medgift.epad.plugins.webservice;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import ch.hevs.medgift.epad.plugins.service.MatlabBeanLocal;
import ch.hevs.medgift.epad.plugins.service.PersistenceBeanLocal;
import ch.hevs.medgift.epad.plugins.service.SVMClassifierBeanLocal;
import ch.hevs.medgift.plugins.common.helpers.ChartConfigAdapterFactory;
import ch.hevs.medgift.plugins.common.helpers.GsonExclusionStrategy;
import ch.hevs.medgift.plugins.common.models.*;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mathworks.toolbox.javabuilder.MWException;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author Abderrahmane
 *
 */
@Stateless
@Path("/epadwebservice")
public class WebServiceResource {

	@EJB
	private MatlabBeanLocal matlab;

	@EJB
	private PersistenceBeanLocal persist;

	@EJB
	private SVMClassifierBeanLocal svm;

    @GET
    public String getDescription(){
        return "ePAD MedGIFT Web Service Resource";
    }

    private Gson gson;

    public WebServiceResource(){
        GsonBuilder builder = new GsonBuilder();
        builder
                .setExclusionStrategies(new GsonExclusionStrategy())
                .registerTypeAdapterFactory(new ChartConfigAdapterFactory(ChartConfigImpl.class));
        gson = builder.create();
    }

	@POST
	@Path("/extractfeatures")
	@Consumes("application/json")
	@Produces("application/json")
	public String extractFeatures(String data) {

		// Convert Gson string to Java EpadObject
		EpadAnalysisPost epadObj = new Gson().fromJson(data, EpadAnalysisPost.class);
		String result = matlab.extractFeatures(epadObj);

        System.out.println("returning : " + result);

		return result;
	}

	@POST
	@Path("/train")
	@Consumes("application/json")
	@Produces("application/json")
	public String trainModel(String data){
        EpadTrainPost epadObj = new Gson().fromJson(data, EpadTrainPost.class);

		String modelFileName = svm.trainModel(epadObj.getModelName(), epadObj.getFeatureList());

		EpadTrainResponse response = new EpadTrainResponse();
		response.setModelName(epadObj.getModelName());
		response.setModelFileName(modelFileName);
		response.setTrainedRegions(epadObj.getFeatureList().size());

        return gson.toJson(response);
	}

	@POST
	@Path("/deleteTrainingModelFeatures")
	@Consumes("application/json")
	@Produces("application/json")
	public String deleteTrainingModelFeatures(String modelFileName){
		boolean deleted = persist.deleteTrainingModelFeatures(modelFileName);
		return deleted + "";
	}

	@POST
	@Path("/classify")
	@Consumes("application/json")
	@Produces("application/json")
	public String classify(String data) {

		// Convert Gson string to Java EpadObject
		EpadClassificationPost epadObj = new Gson().fromJson(data, EpadClassificationPost.class);

        Map<String, EpadClassificationResponse> classificationResponseMap = new LinkedHashMap<>();
        for(QuantitativeImagingFeatures features : epadObj.getFeaturesToClassify()){
            EpadClassificationResponse classification = svm.classify(features.getFeatureValues(), epadObj.getModelFileName());
            classificationResponseMap.put(features.getImageAnnotation().getName(), classification);
        }

		return gson.toJson(classificationResponseMap);
	}

	@GET
	@Path("/checkenv")
	@Produces("application/json")
	public String checkEnv(){
		return "LD_LIBRARY_PATH : " + System.getenv("LD_LIBRARY_PATH") + ", java.library.path : " + System.getProperty("java.library.path");
	}

	@GET
	@Path("/testmatlab")
	@Produces("application/json")
	public String testMatlab() throws MWException {
		return matlab.testMCR();
	}

	@POST
	@Path("/segmentLung")
	@Consumes("application/json")
	@Produces("application/json")
	public String segmentLung(String data){

		EpadSegmentationPost epadObj = new Gson().fromJson(data, EpadSegmentationPost.class);

		String outputPaths = matlab.segmentLung(epadObj);
		return outputPaths;
	}

}
