/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core;

import ch.icosys.popjava.core.PJMethodFilter;
import ch.icosys.popjava.core.PJMethodHandler;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.ClassUtil;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.SystemUtil;
import ch.icosys.popjava.core.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class PJProxyFactory
extends ProxyFactory {
    protected final Class<?> targetClass;

    public PJProxyFactory(Class<?> targetClass) {
        this.targetClass = targetClass;
        try {
            targetClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new POPException(10020, "Class " + targetClass.getName() + " does not have a default constructor");
        }
        this.setSuperclass(targetClass);
        PJMethodFilter methodFilter = new PJMethodFilter();
        this.setFilter(methodFilter);
    }

    public Object newPOPObject(Broker parentBroker, Object ... argvs) throws POPException {
        ObjectDescription objectDescription = POPSystem.getDefaultOD();
        return this.newPOPObject(parentBroker, objectDescription, argvs);
    }

    private static Constructor<?> findMatchingConstructor(Class<?> targetClass, Class<?>[] parameterTypes) {
        Constructor<?> constructor = null;
        for (Constructor<?> candidate : targetClass.getConstructors()) {
            if (candidate.getParameterTypes().length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i].isAssignableFrom(candidate.getParameterTypes()[i]) || candidate.getParameterTypes()[i].isAssignableFrom(parameterTypes[i]) || ClassUtil.isAssignableFrom(parameterTypes[i], candidate.getParameterTypes()[i])) continue;
                matches = false;
            }
            if (!matches) continue;
            if (constructor == null) {
                constructor = candidate;
                continue;
            }
            constructor = null;
            break;
        }
        return constructor;
    }

    public Object newPOPObject(Broker parentBroker, ObjectDescription od, Object ... argvs) throws POPException {
        try {
            Constructor<?> constructor;
            POPObject popObject = null;
            Class<?>[] parameterTypes = ClassUtil.getObjectTypes(argvs);
            try {
                constructor = this.targetClass.getConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                constructor = PJProxyFactory.findMatchingConstructor(this.targetClass, parameterTypes);
            }
            if (constructor == null) {
                System.out.println("No constructor found");
            }
            popObject = (POPObject)this.targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            popObject.loadPOPAnnotations(constructor, argvs);
            ObjectDescription originalOd = popObject.getOd();
            originalOd.merge(od);
            if (originalOd.useLocalJVM()) {
                if (originalOd.getHostName() != null && !originalOd.getHostName().isEmpty() && !Util.isLocal(originalOd.getHostName())) {
                    throw new POPException(10021, "Object can't define URL and run in local JVM");
                }
                popObject = (POPObject)constructor.newInstance(argvs);
                popObject.loadPOPAnnotations(constructor, argvs);
                Broker broker = new Broker(popObject);
                SystemUtil.registerLocalJVM(broker);
                return popObject;
            }
            if (originalOd.getRemoteAccessPoint() != null && !originalOd.getRemoteAccessPoint().isEmpty()) {
                POPAccessPoint accessPoint = new POPAccessPoint();
                accessPoint.setAccessString(originalOd.getRemoteAccessPoint());
                return this.bindPOPObject(parentBroker, accessPoint, null);
            }
            PJMethodHandler methodHandler = new PJMethodHandler(parentBroker, popObject);
            methodHandler.setOd(originalOd);
            methodHandler.popConstructor(this.targetClass, argvs);
            Class c = this.createClass();
            Object result = c.newInstance();
            ((ProxyObject)result).setHandler((MethodHandler)methodHandler);
            return result;
        }
        catch (POPException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof POPException) {
                throw (POPException)e.getCause();
            }
            LogWriter.writeExceptionLog(e);
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
        }
        return null;
    }

    public Object bindPOPObject(Broker parentBroker, POPAccessPoint accessPoint, String networkUUID) throws POPException {
        try {
            Constructor<?> constructor = this.targetClass.getConstructor(new Class[0]);
            POPObject popObject = (POPObject)constructor.newInstance(new Object[0]);
            popObject.loadPOPAnnotations(constructor, new Object[0]);
            PJMethodHandler methodHandler = new PJMethodHandler(parentBroker, popObject);
            if (networkUUID != null) {
                methodHandler.getOD().setNetwork(networkUUID);
            }
            methodHandler.bindObject(accessPoint);
            Class c = this.createClass();
            Object result = c.newInstance();
            ((ProxyObject)result).setHandler((MethodHandler)methodHandler);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new POPException(0, e.getMessage());
        }
    }

    public Object newActiveFromBuffer(Combox<?> sourceCombox, POPBuffer buffer) throws POPException {
        POPObject result = null;
        try {
            Constructor<?> constructor = this.targetClass.getConstructor(new Class[0]);
            POPObject popObject = (POPObject)constructor.newInstance(new Object[0]);
            popObject.loadPOPAnnotations(constructor, new Object[0]);
            PJMethodHandler methodHandler = new PJMethodHandler(null, popObject);
            methodHandler.setSetup();
            Class c = this.createClass();
            result = (POPObject)c.newInstance();
            ((ProxyObject)result).setHandler((MethodHandler)methodHandler);
            if (!result.deserialize(sourceCombox, buffer)) {
                LogWriter.writeDebugInfo("bad deserialize");
                POPException.throwObjectBindException(methodHandler.getAccessPoint());
            }
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
        }
        LogWriter.writeDebugInfo("result");
        return result;
    }
}

