/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.broker;

import ch.icosys.popjava.core.broker.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RequestQueue {
    private final Lock lock = new ReentrantLock();
    private final Condition canPeek = this.lock.newCondition();
    private final Condition canInsert = this.lock.newCondition();
    private final List<Request> requestsConc = new ArrayList<Request>();
    private final List<Request> requestsSeq = new ArrayList<Request>();
    private final List<Request> requestsMutex = new ArrayList<Request>();
    private int requestType = 0;
    private final List<List<Request>> requests = new ArrayList<List<Request>>();
    private Request servingMutex = null;
    private Request servingSequential = null;
    private final ArrayList<Request> servingConcurrent = new ArrayList();
    private Request availableRequest = null;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = 250;
    private int maxQueue = 250;

    public RequestQueue() {
        this.requests.add(this.requestsConc);
        this.requests.add(this.requestsSeq);
        this.requests.add(this.requestsMutex);
    }

    public synchronized int size() {
        return this.requestsConc.size() + this.requestsSeq.size() + this.requestsMutex.size() + (this.servingMutex == null ? 0 : 1) + this.servingConcurrent.size() + (this.servingSequential == null ? 0 : 1);
    }

    public synchronized int getMaxQueue() {
        return this.maxQueue;
    }

    public synchronized void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    public boolean add(Request request) {
        this.lock.lock();
        try {
            if (request.isConcurrent()) {
                while (this.requestsConc.size() + this.servingConcurrent.size() >= this.maxQueue) {
                    this.canInsert.await();
                }
                this.requestsConc.add(request);
            } else if (request.isSequential()) {
                while (this.requestsSeq.size() >= this.maxQueue) {
                    this.canInsert.await();
                }
                this.requestsSeq.add(request);
            } else if (request.isMutex()) {
                while (this.requestsMutex.size() >= this.maxQueue) {
                    this.canInsert.await();
                }
                this.requestsMutex.add(request);
            }
            this.canPeek();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request peek(int time, TimeUnit timeUnit) {
        Request request = null;
        boolean waitSuccess = false;
        this.lock.lock();
        try {
            boolean bl = waitSuccess = this.availableRequest != null || this.canPeek.await(time, timeUnit);
            if (waitSuccess) {
                request = this.availableRequest;
                request.setStatus(1);
                this.serveRequest(request);
                this.availableRequest = null;
                this.canPeek();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
        return request;
    }

    private void serveRequest(Request request) {
        if (request.isMutex()) {
            this.servingMutex = request;
        } else if (request.isSequential()) {
            this.servingSequential = request;
        } else {
            this.servingConcurrent.add(request);
        }
    }

    public boolean remove(Request request) {
        this.lock.lock();
        try {
            if (request.isMutex() && this.servingMutex == request) {
                this.servingMutex = null;
                this.requestsMutex.remove(request);
            } else if (request.isSequential() && this.servingSequential == request) {
                this.servingSequential = null;
                this.requestsSeq.remove(request);
            } else {
                this.servingConcurrent.remove(request);
                this.requestsConc.remove(request);
            }
            this.canPeek();
            this.canInsert.signal();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public synchronized boolean clear() {
        this.availableRequest = null;
        this.requestsConc.clear();
        this.requestsMutex.clear();
        this.requestsSeq.clear();
        this.servingMutex = null;
        this.servingSequential = null;
        this.servingConcurrent.clear();
        return true;
    }

    public boolean canPeek() {
        this.requestType = (this.requestType + 1) % this.requests.size();
        if (this.availableRequest == null) {
            for (int i = 0; i < 3; ++i) {
                if (!this.canPeekType(this.requests.get((this.requestType + i) % this.requests.size()))) continue;
                this.canPeek.signal();
                return true;
            }
        } else {
            this.canPeek.signal();
            return true;
        }
        return false;
    }

    private boolean canPeekType(List<Request> requests) {
        for (int i = 0; i < requests.size(); ++i) {
            Request currentRequest = requests.get(i);
            if (!this.canPeek(currentRequest)) continue;
            if (this.availableRequest == null) {
                this.availableRequest = currentRequest;
                requests.remove(i);
            }
            return true;
        }
        return false;
    }

    private boolean canPeek(Request request) {
        if (request.getStatus() != 0) {
            return false;
        }
        if (this.servingMutex != null && this.servingMutex.getStatus() == 1) {
            return false;
        }
        if (request.isMutex() || request.isSequential()) {
            if (this.servingSequential != null && this.servingSequential.getStatus() == 1) {
                return false;
            }
            if (request.isMutex()) {
                for (Request currentRequest : this.servingConcurrent) {
                    if (currentRequest.getStatus() != 1 || !currentRequest.isMutex()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

