/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket;

import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ComboxSocket<T extends Socket>
extends Combox<T> {
    public static final int BUFFER_LENGTH = 0x800000;
    protected static final int STREAM_BUFFER_SIZE = 0x800000;
    protected final byte[] receivedBuffer = new byte[0x800000];
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;

    public ComboxSocket() {
    }

    public ComboxSocket(String networkUUID) {
        super(networkUUID);
    }

    @Override
    protected boolean serverAccept() {
        try {
            this.inputStream = new BufferedInputStream(((Socket)this.peerConnection).getInputStream(), 0x800000);
            this.outputStream = new BufferedOutputStream(((Socket)this.peerConnection).getOutputStream(), 0x800000);
            return true;
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[ComboxSocket] Couldn't open streams on the server side.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receive(POPBuffer buffer, int requestId, int connectionID) {
        int result = 0;
        try {
            buffer.resetToReceive();
            byte[] temp = new byte[4];
            boolean gotPacket = false;
            boolean yieldThread = false;
            do {
                if (yieldThread) {
                    Thread.yield();
                    Thread.sleep(1L);
                }
                yieldThread = false;
                InputStream inputStream = this.inputStream;
                synchronized (inputStream) {
                    this.inputStream.mark(12);
                    if (this.peakHeadInteger(temp)) {
                        return -1;
                    }
                    int messageLength = buffer.getTranslatedInteger(temp);
                    if (messageLength <= 0) {
                        this.closeInternal();
                        return -1;
                    }
                    if (this.peakHeadInteger(temp)) {
                        return -1;
                    }
                    int packetConnectionID = buffer.getTranslatedInteger(temp);
                    if (this.peakHeadInteger(temp)) {
                        return -1;
                    }
                    int requestIdPacket = buffer.getTranslatedInteger(temp);
                    this.registerCommuncation();
                    if (packetConnectionID == 0 && requestIdPacket == 2 && requestId != 2) {
                        POPBuffer tempBuffer = this.getBufferFactory().createBuffer();
                        tempBuffer.resetToReceive();
                        int length = this.readPacket(tempBuffer, messageLength, requestIdPacket, packetConnectionID);
                        if (length >= 28) {
                            tempBuffer.extractHeader();
                        }
                        if (tempBuffer.getHeader().getRequestType() == 1) {
                            this.inputStream.reset();
                            yieldThread = true;
                            continue;
                        }
                        this.handleComboxMessages(tempBuffer);
                        continue;
                    }
                    if (packetConnectionID != connectionID) {
                        this.inputStream.reset();
                        yieldThread = true;
                        continue;
                    }
                    if (requestId == -1 || requestIdPacket == -1 || requestIdPacket == requestId) {
                        gotPacket = true;
                        result = this.readPacket(buffer, messageLength, requestIdPacket, packetConnectionID);
                    } else {
                        this.inputStream.reset();
                        yieldThread = true;
                    }
                }
            } while (!gotPacket);
            int headerLength = 28;
            if (result < headerLength) {
                if (this.conf.isDebugCombox()) {
                    String logInfo = String.format("[ComboxSecureSocket] failed to receive header. receivedLength= %d, Message length %d", result, headerLength);
                    LogWriter.writeDebugInfo(logInfo);
                }
                this.closeInternal();
            } else {
                buffer.extractHeader();
            }
            return result;
        }
        catch (Exception e) {
            if (this.conf.isDebugCombox()) {
                LogWriter.writeDebugInfo("[ComboxSocket] Error while receiving data:" + e.getMessage());
            }
            this.closeInternal();
            return -2;
        }
    }

    private boolean peakHeadInteger(byte[] temp) throws IOException {
        int tempRead;
        for (int read = 0; read < temp.length; read += tempRead) {
            tempRead = this.inputStream.read(temp, read, temp.length - read);
            if (tempRead >= 0) continue;
            this.closeInternal();
            return true;
        }
        return false;
    }

    private int readPacket(POPBuffer buffer, int messageLength, int requestIdPacket, int packetConnectionID) throws IOException {
        int count;
        this.registerCommuncation();
        int result = 12;
        buffer.putInt(messageLength);
        messageLength -= 4;
        buffer.putInt(packetConnectionID);
        messageLength -= 4;
        buffer.putInt(requestIdPacket);
        messageLength -= 4;
        int receivedLength = 0;
        while (messageLength > 0 && (receivedLength = this.inputStream.read(this.receivedBuffer, 0, count = messageLength < 0x800000 ? messageLength : 0x800000)) > 0) {
            messageLength -= receivedLength;
            result += receivedLength;
            buffer.put(this.receivedBuffer, 0, receivedLength);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(POPBuffer buffer) {
        try {
            buffer.packMessageHeader();
            int length = buffer.size();
            byte[] dataSend = buffer.array();
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                this.outputStream.write(dataSend, 0, length);
                this.outputStream.flush();
            }
            return length;
        }
        catch (Exception e) {
            if (this.conf.isDebugCombox()) {
                LogWriter.writeDebugInfo("[ComboxSocket] -Send:  Error while sending data - " + e.getMessage() + " " + this.outputStream);
            }
            this.closeInternal();
            return -1;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.closeInternal();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void closeInternal() {
        try {
            if (this.peerConnection != null && !((Socket)this.peerConnection).isClosed()) {
                ((Socket)this.peerConnection).sendUrgentData(-1);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            if (this.peerConnection != null) {
                try {
                    ((Socket)this.peerConnection).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        if (this.peerConnection != null) {
            return ((Socket)this.peerConnection).toString();
        }
        return "Closed";
    }

    public static List<AccessPoint> getSortedAccessPoints(String myHost, POPAccessPoint accessPoint, String protocol) {
        ArrayList<AccessPoint> aps = new ArrayList<AccessPoint>();
        for (int i = 0; i < accessPoint.size(); ++i) {
            AccessPoint ap = accessPoint.get(i);
            if (ap.getProtocol().compareToIgnoreCase(protocol) != 0) continue;
            aps.add(ap);
        }
        int countPoints = myHost.length() - myHost.replace(".", "").length();
        if (countPoints == 3) {
            final String subnet = myHost.substring(0, myHost.indexOf("."));
            Collections.sort(aps, new Comparator<AccessPoint>(){

                @Override
                public int compare(AccessPoint o1, AccessPoint o2) {
                    int countPoints2;
                    int countPoints1 = o1.getHost().length() - o1.getHost().replace(".", "").length();
                    if (countPoints1 == (countPoints2 = o2.getHost().length() - o2.getHost().replace(".", "").length())) {
                        if (o1.getHost().startsWith(subnet) && o2.getHost().startsWith(subnet)) {
                            return o1.getHost().compareTo(o2.getHost());
                        }
                        if (o1.getHost().startsWith(subnet)) {
                            return -1;
                        }
                        if (o2.getHost().startsWith(subnet)) {
                            return 1;
                        }
                        boolean privateSubnet1 = ComboxSocket.isHostInPrivateSubnet(o1.getHost());
                        boolean privateSubnet2 = ComboxSocket.isHostInPrivateSubnet(o2.getHost());
                        if (privateSubnet1 && !privateSubnet2) {
                            return 1;
                        }
                        if (!privateSubnet1 && privateSubnet2) {
                            return -1;
                        }
                        return o1.getHost().compareTo(o2.getHost());
                    }
                    return countPoints1 - countPoints2;
                }
            });
        }
        return aps;
    }

    private static boolean isHostInPrivateSubnet(String host) {
        return host.startsWith("10.") || host.startsWith("172.16.") || host.startsWith("192.168.");
    }
}

