/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.ssl;

import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.socket.ComboxSocket;
import ch.icosys.popjava.core.combox.socket.ssl.ComboxSecureSocketFactory;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ComboxSecureSocket
extends ComboxSocket<SSLSocket> {
    protected static final ComboxFactory MY_FACTORY = new ComboxSecureSocketFactory();

    public ComboxSecureSocket() {
    }

    public ComboxSecureSocket(String networkUUID) {
        super(networkUUID);
    }

    @Override
    protected boolean connectToServer() {
        try {
            SSLContext sslContext = SSLUtils.getSSLContext();
            SSLSocketFactory factory = sslContext.getSocketFactory();
            this.available = false;
            List<AccessPoint> aps = ComboxSecureSocket.getSortedAccessPoints(POPSystem.getHostIP(), this.accessPoint, "ssl");
            for (int i = 0; i < aps.size() && !this.available; ++i) {
                AccessPoint ap = aps.get(i);
                String host = ap.getHost();
                int port = ap.getPort();
                System.out.println("Connect secure " + host + " " + port + " " + POPSystem.getHostIP());
                try {
                    InetSocketAddress sockaddress = new InetSocketAddress(host, port);
                    if (this.timeOut > 0) {
                        this.peerConnection = (SSLSocket)factory.createSocket();
                    } else {
                        this.peerConnection = (SSLSocket)factory.createSocket();
                        this.timeOut = 0;
                    }
                    ((SSLSocket)this.peerConnection).setUseClientMode(true);
                    SNIHostName network = new SNIHostName(this.getNetworkUUID());
                    ArrayList<SNIServerName> nets = new ArrayList<SNIServerName>(1);
                    nets.add(network);
                    SSLParameters parameters = ((SSLSocket)this.peerConnection).getSSLParameters();
                    parameters.setServerNames(nets);
                    ((SSLSocket)this.peerConnection).setSSLParameters(parameters);
                    ((SSLSocket)this.peerConnection).connect(sockaddress);
                    this.inputStream = new BufferedInputStream(((SSLSocket)this.peerConnection).getInputStream());
                    this.outputStream = new BufferedOutputStream(((SSLSocket)this.peerConnection).getOutputStream());
                    this.available = true;
                    continue;
                }
                catch (IOException e) {
                    this.available = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.available;
    }

    @Override
    protected boolean sendNetworkName() {
        try {
            ((SSLSocket)this.peerConnection).startHandshake();
            return true;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[ComboxSecureSocket] Client handshake failed. Message: %s", e.getMessage());
            return false;
        }
    }

    @Override
    protected boolean receiveNetworkName() {
        ExtendedSSLSession handshakeSession = (ExtendedSSLSession)((SSLSocket)this.peerConnection).getSession();
        if (handshakeSession != null) {
            for (SNIServerName sniNetwork : handshakeSession.getRequestedServerNames()) {
                if (sniNetwork.getType() != 0) continue;
                this.setNetworkUUID(((SNIHostName)sniNetwork).getAsciiName());
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean exportConnectionInfo() {
        try {
            Certificate[] certs;
            for (Certificate cert : certs = ((SSLSocket)this.peerConnection).getSession().getPeerCertificates()) {
                if (!SSLUtils.isCertificateKnown(cert)) continue;
                String fingerprint = SSLUtils.certificateFingerprint(cert);
                this.accessPoint.setFingerprint(fingerprint);
                if (this.getNetworkUUID() == null) {
                    this.setNetworkUUID(SSLUtils.getNetworkFromFingerprint(fingerprint));
                }
                this.remoteCaller = new POPRemoteCaller(((SSLSocket)this.peerConnection).getInetAddress(), MY_FACTORY.getComboxName(), this.getNetworkUUID(), MY_FACTORY.isSecure(), fingerprint);
                return true;
            }
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
        }
        return false;
    }
}

